/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.mgt;

import java.lang.reflect.Field;
import org.apache.shiro.mgt.DefaultSessionStorageEvaluator;
import org.apache.shiro.mgt.SessionStorageEvaluator;
import org.apache.shiro.mgt.SubjectDAO;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.apache.shiro.subject.support.DelegatingSubject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSubjectDAO
implements SubjectDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSubjectDAO.class);
    private SessionStorageEvaluator sessionStorageEvaluator = new DefaultSessionStorageEvaluator();

    protected boolean isSessionStorageEnabled(Subject subject) {
        return this.getSessionStorageEvaluator().isSessionStorageEnabled(subject);
    }

    public SessionStorageEvaluator getSessionStorageEvaluator() {
        return this.sessionStorageEvaluator;
    }

    public void setSessionStorageEvaluator(SessionStorageEvaluator sessionStorageEvaluator) {
        this.sessionStorageEvaluator = sessionStorageEvaluator;
    }

    @Override
    public Subject save(Subject subject) {
        if (this.isSessionStorageEnabled(subject)) {
            this.saveToSession(subject);
        } else {
            LOGGER.trace("Session storage of subject state for Subject [{}] has been disabled: identity and authentication state are expected to be initialized on every request or invocation.", (Object)subject);
        }
        return subject;
    }

    protected void saveToSession(Subject subject) {
        this.mergePrincipals(subject);
        this.mergeAuthenticationState(subject);
    }

    private static boolean isEmpty(PrincipalCollection pc) {
        return pc == null || pc.isEmpty();
    }

    protected void mergePrincipals(Subject subject) {
        Session session;
        PrincipalCollection currentPrincipals = null;
        if (subject.isRunAs() && subject instanceof DelegatingSubject) {
            try {
                Field field = DelegatingSubject.class.getDeclaredField("principals");
                field.setAccessible(true);
                currentPrincipals = (PrincipalCollection)field.get(subject);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to access DelegatingSubject principals property.", e);
            }
        }
        if (currentPrincipals == null || currentPrincipals.isEmpty()) {
            currentPrincipals = subject.getPrincipals();
        }
        if ((session = subject.getSession(false)) == null) {
            if (!DefaultSubjectDAO.isEmpty(currentPrincipals)) {
                session = subject.getSession();
                session.setAttribute(DefaultSubjectContext.PRINCIPALS_SESSION_KEY, currentPrincipals);
            }
        } else {
            PrincipalCollection existingPrincipals = (PrincipalCollection)session.getAttribute(DefaultSubjectContext.PRINCIPALS_SESSION_KEY);
            if (DefaultSubjectDAO.isEmpty(currentPrincipals)) {
                if (!DefaultSubjectDAO.isEmpty(existingPrincipals)) {
                    session.removeAttribute(DefaultSubjectContext.PRINCIPALS_SESSION_KEY);
                }
            } else if (!currentPrincipals.equals(existingPrincipals)) {
                session.setAttribute(DefaultSubjectContext.PRINCIPALS_SESSION_KEY, currentPrincipals);
            }
        }
    }

    protected void mergeAuthenticationState(Subject subject) {
        Session session = subject.getSession(false);
        if (session == null) {
            if (subject.isAuthenticated()) {
                session = subject.getSession();
                session.setAttribute(DefaultSubjectContext.AUTHENTICATED_SESSION_KEY, Boolean.TRUE);
            }
        } else {
            Boolean existingAuthc = (Boolean)session.getAttribute(DefaultSubjectContext.AUTHENTICATED_SESSION_KEY);
            if (subject.isAuthenticated()) {
                if (existingAuthc == null || !existingAuthc.booleanValue()) {
                    session.setAttribute(DefaultSubjectContext.AUTHENTICATED_SESSION_KEY, Boolean.TRUE);
                }
            } else if (existingAuthc != null) {
                session.removeAttribute(DefaultSubjectContext.AUTHENTICATED_SESSION_KEY);
            }
        }
    }

    protected void removeFromSession(Subject subject) {
        Session session = subject.getSession(false);
        if (session != null) {
            session.removeAttribute(DefaultSubjectContext.AUTHENTICATED_SESSION_KEY);
            session.removeAttribute(DefaultSubjectContext.PRINCIPALS_SESSION_KEY);
        }
    }

    @Override
    public void delete(Subject subject) {
        this.removeFromSession(subject);
    }
}

