/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.HashSet;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.AtomicSortComparer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

public class DistinctValues
extends CollatingFunction {
    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.argument[0].iterate(xPathContext);
        return new DistinctIterator(sequenceIterator, this.getAtomicSortComparer(1, xPathContext));
    }

    protected AtomicSortComparer getAtomicSortComparer(int n, XPathContext xPathContext) throws XPathException {
        AtomicSortComparer atomicSortComparer = new AtomicSortComparer(this.getCollator(n, xPathContext), xPathContext == null ? this.conversionContext : xPathContext);
        return atomicSortComparer;
    }

    public static class DistinctIterator
    implements SequenceIterator {
        private SequenceIterator base;
        private AtomicSortComparer comparer;
        private int position;
        private AtomicValue current;
        private HashSet lookup = new HashSet(40);

        public DistinctIterator(SequenceIterator sequenceIterator, AtomicSortComparer atomicSortComparer) {
            this.base = sequenceIterator;
            this.comparer = atomicSortComparer;
            this.position = 0;
        }

        public Item next() throws XPathException {
            AtomicValue atomicValue;
            AtomicSortComparer.ComparisonKey comparisonKey;
            do {
                if ((atomicValue = (AtomicValue)this.base.next()) != null) continue;
                this.current = null;
                this.position = -1;
                return null;
            } while (this.lookup.contains(comparisonKey = this.comparer.getComparisonKey(atomicValue)));
            this.lookup.add(comparisonKey);
            this.current = atomicValue;
            ++this.position;
            return atomicValue;
        }

        public Item current() {
            return this.current;
        }

        public int position() {
            return this.position;
        }

        public SequenceIterator getAnother() throws XPathException {
            return new DistinctIterator(this.base.getAnother(), this.comparer);
        }

        public int getProperties() {
            return 0;
        }
    }
}

