/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jackrabbit.oak.exercise.security.authorization.advanced;

import org.apache.jackrabbit.oak.AbstractSecurityTest;

/**
 * <pre>
 * Module: Advanced Authorization Topics
 * =============================================================================
 *
 * Title: Introduction to Advanced Authorization Topics
 * -----------------------------------------------------------------------------
 *
 * Goal:
 * Become familiar with the following advanced authorization topics:
 *
 * - Aggregation of multiple authorization models in the Oak security setup
 * - Understanding how authorization with multiple authorization models.
 * - Writing custom authorization models
 *
 * Exercises:
 *
 * - Read http://jackrabbit.apache.org/oak/docs/security/introduction.html
 * - Read http://jackrabbit.apache.org/oak/docs/security/authorization/composite.html
 *
 * </pre>
 */
public class L1_IntroductionTest extends AbstractSecurityTest {


}