/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.nifi;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;
import org.apache.nifi.web.api.dto.FlowAnalysisRuleDTO;
import org.apache.nifi.web.api.entity.FlowAnalysisRuleEntity;
import org.apache.nifi.web.api.entity.FlowAnalysisRulesEntity;

public class FlowAnalysisRulesResult
extends AbstractWritableResult<FlowAnalysisRulesEntity> {
    private final FlowAnalysisRulesEntity flowAnalysisRulesEntity;

    public FlowAnalysisRulesResult(ResultType resultType, FlowAnalysisRulesEntity flowAnalysisRulesEntity) {
        super(resultType);
        this.flowAnalysisRulesEntity = Objects.requireNonNull(flowAnalysisRulesEntity);
    }

    @Override
    protected void writeSimpleResult(PrintStream output) throws IOException {
        Set ruleEntities = this.flowAnalysisRulesEntity.getFlowAnalysisRules();
        if (ruleEntities == null) {
            return;
        }
        List ruleDTOS = ruleEntities.stream().map(FlowAnalysisRuleEntity::getComponent).sorted(Comparator.comparing(FlowAnalysisRuleDTO::getName)).collect(Collectors.toList());
        Table table = new Table.Builder().column("#", 3, 3, false).column("Name", 5, 40, true).column("ID", 36, 36, false).column("Type", 5, 40, true).column("State", 10, 20, false).build();
        for (int i = 0; i < ruleDTOS.size(); ++i) {
            FlowAnalysisRuleDTO ruleDTO = (FlowAnalysisRuleDTO)ruleDTOS.get(i);
            String[] typeSplit = ruleDTO.getType().split("\\.", -1);
            table.addRow(String.valueOf(i + 1), ruleDTO.getName(), ruleDTO.getId(), typeSplit[typeSplit.length - 1], ruleDTO.getState());
        }
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }

    @Override
    public FlowAnalysisRulesEntity getResult() {
        return this.flowAnalysisRulesEntity;
    }
}

