/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import java.text.Normalizer;
import java.util.Objects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;

public final class StringBuilders {
    private static final String ASCII = "AAAAAA\u00c6CEEEEIIIIDNOOOOO*OUUUUY\u00desaaaaaa\u00e6ceeeeiiiionooooo/ouuuuy\u00fey";

    private StringBuilders() {
    }

    public static int trimWhitespaces(StringBuilder buffer, int lower, int upper) {
        ArgumentChecks.ensureNonNull("buffer", buffer);
        int i = CharSequences.skipTrailingWhitespaces(buffer, lower, upper);
        int length = buffer.length();
        buffer.delete(i, upper).delete(lower, CharSequences.skipLeadingWhitespaces(buffer, lower, i));
        return length - buffer.length();
    }

    public static void replace(StringBuilder buffer, char toSearch, char replaceBy) {
        ArgumentChecks.ensureNonNull("buffer", buffer);
        if (toSearch != replaceBy) {
            int i = buffer.length();
            while (--i >= 0) {
                if (buffer.charAt(i) != toSearch) continue;
                buffer.setCharAt(i, replaceBy);
            }
        }
    }

    public static void replace(StringBuilder buffer, String toSearch, String replaceBy) {
        ArgumentChecks.ensureNonNull("buffer", buffer);
        ArgumentChecks.ensureNonEmpty("toSearch", toSearch);
        ArgumentChecks.ensureNonNull("replaceBy", replaceBy);
        if (!toSearch.equals(replaceBy)) {
            int length = toSearch.length();
            int i = buffer.length();
            while ((i = buffer.lastIndexOf(toSearch, i)) >= 0) {
                buffer.replace(i, i + length, replaceBy);
                i -= length;
            }
        }
    }

    public static void replace(StringBuilder buffer, int start, int end, char[] chars) {
        ArgumentChecks.ensureNonNull("buffer", buffer);
        ArgumentChecks.ensureNonNull("chars", chars);
        int length = end - start;
        if (start < 0 || length < 0) {
            throw new StringIndexOutOfBoundsException(Errors.format((short)76, start, end));
        }
        int remaining = chars.length - length;
        if (remaining < 0) {
            buffer.delete(end + remaining, end);
            length = chars.length;
        }
        for (int i = 0; i < length; ++i) {
            buffer.setCharAt(start++, chars[i]);
        }
        if (remaining > 0) {
            buffer.insert(start, chars, length, remaining);
        }
    }

    public static void remove(StringBuilder buffer, String toSearch) {
        ArgumentChecks.ensureNonNull("buffer", buffer);
        ArgumentChecks.ensureNonEmpty("toSearch", toSearch);
        int length = toSearch.length();
        int i = buffer.lastIndexOf(toSearch);
        while (i >= 0) {
            buffer.delete(i, i + length);
            i = buffer.lastIndexOf(toSearch, i);
        }
    }

    public static void repeat(StringBuilder buffer, int offset, char c, int count) {
        switch (count) {
            case 0: {
                break;
            }
            case 1: {
                buffer.insert(offset, c);
                break;
            }
            default: {
                CharSequence r;
                ArgumentChecks.ensurePositive("count", count);
                switch (c) {
                    case ' ': {
                        r = CharSequences.spaces(count);
                        break;
                    }
                    case '0': {
                        r = Repeat.ZERO;
                        break;
                    }
                    default: {
                        r = new Repeat(c, count);
                    }
                }
                buffer.insert(offset, r, 0, count);
                break;
            }
        }
    }

    public static void trimFractionalPart(StringBuilder buffer) {
        int i = buffer.length();
        block4: while (i > 0) {
            switch (buffer.charAt(--i)) {
                case '0': {
                    continue block4;
                }
                case '.': {
                    buffer.setLength(i);
                }
            }
            return;
        }
    }

    public static void toASCII(StringBuilder buffer) {
        StringBuilders.toASCII(Objects.requireNonNull(buffer), buffer);
    }

    static CharSequence toASCII(CharSequence text, StringBuilder buffer) {
        if (text != null) {
            boolean doneNFKD = false;
            int i = text.length();
            block14: while (i > 0) {
                char cr;
                int c = Character.codePointBefore(text, i);
                int n = Character.charCount(c);
                int r = c - 192;
                i -= n;
                if (r < 0) continue;
                if (r < ASCII.length()) {
                    cr = ASCII.charAt(r);
                } else {
                    block0 : switch (Character.getType(c)) {
                        case 6: 
                        case 15: 
                        case 16: {
                            cr = '\u0000';
                            break;
                        }
                        case 13: 
                        case 14: {
                            cr = '\n';
                            break;
                        }
                        case 12: {
                            cr = ' ';
                            break;
                        }
                        case 29: {
                            cr = c == 8216 ? (char)'\'' : '\"';
                            break;
                        }
                        case 30: {
                            cr = c == 8217 ? (char)'\'' : '\"';
                            break;
                        }
                        case 24: 
                        case 25: {
                            switch (c) {
                                case 8901: {
                                    cr = '*';
                                    break block0;
                                }
                                case 8725: {
                                    cr = '/';
                                    break block0;
                                }
                                case 8242: {
                                    cr = '\'';
                                    break block0;
                                }
                                case 8243: {
                                    cr = '\"';
                                    break block0;
                                }
                            }
                            continue block14;
                        }
                        default: {
                            if (doneNFKD) continue block14;
                            doneNFKD = true;
                            String decomposed = Normalizer.normalize(text, Normalizer.Form.NFKD);
                            if (decomposed.contentEquals(text)) continue block14;
                            if (buffer == null) {
                                buffer = new StringBuilder(decomposed.length());
                                text = buffer;
                            } else {
                                buffer.setLength(0);
                            }
                            i = buffer.append(decomposed).length();
                            continue block14;
                        }
                    }
                }
                if (buffer == null) {
                    buffer = new StringBuilder(text.length()).append(text);
                    text = buffer;
                }
                if (cr == '\u0000') {
                    buffer.delete(i, i + n);
                    continue;
                }
                if (n == 2) {
                    buffer.deleteCharAt(i + 1);
                }
                buffer.setCharAt(i, cr);
            }
        }
        return text;
    }

    private static final class Repeat
    implements CharSequence {
        static final Repeat ZERO = new Repeat('0', Integer.MAX_VALUE);
        private final char c;
        private final int n;

        Repeat(char c, int n) {
            this.c = c;
            this.n = n;
        }

        @Override
        public int length() {
            return this.n;
        }

        @Override
        public char charAt(int i) {
            return this.c;
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new Repeat(this.c, end - start);
        }
    }
}

