/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.apache.sis.geometry.AbstractDirectPosition;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class ImmutableDirectPosition
extends AbstractDirectPosition
implements Serializable {
    private static final long serialVersionUID = -4275832076346637274L;
    private final CoordinateReferenceSystem crs;
    private final double[] coordinates;

    public ImmutableDirectPosition(CoordinateReferenceSystem crs, double ... coordinates) throws MismatchedDimensionException {
        this.crs = crs;
        this.coordinates = (double[])coordinates.clone();
        ArgumentChecks.ensureDimensionMatches((String)"crs", (int)coordinates.length, (CoordinateReferenceSystem)crs);
    }

    public static ImmutableDirectPosition castOrCopy(DirectPosition position) {
        if (position == null || position instanceof ImmutableDirectPosition) {
            return (ImmutableDirectPosition)position;
        }
        return new ImmutableDirectPosition(position.getCoordinateReferenceSystem(), position.getCoordinate());
    }

    public int getDimension() {
        return this.coordinates.length;
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    @Override
    public double[] getCoordinates() {
        return (double[])this.coordinates.clone();
    }

    @Override
    public double getCoordinate(int dimension) throws IndexOutOfBoundsException {
        return this.coordinates[dimension];
    }

    @Override
    public String toString() {
        return ImmutableDirectPosition.toString(this, ArraysExt.isSinglePrecision((double[])this.coordinates));
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.coordinates) + Objects.hashCode(this.crs);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ImmutableDirectPosition) {
            ImmutableDirectPosition that = (ImmutableDirectPosition)object;
            return Arrays.equals(this.coordinates, that.coordinates) && Objects.equals(this.crs, that.crs);
        }
        return super.equals(object);
    }
}

