/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.sis.referencing.factory;

import org.opengis.util.FactoryException;


/**
 * Thrown when a factory contains invalid data.
 *
 * <h2>Example</h2>
 * An EPSG database record containing a null value in a column where nulls should not have been allowed.
 *
 * @author  Martin Desruisseaux (Geomatys)
 * @version 1.2
 *
 * @see MissingFactoryResourceException
 *
 * @since 0.7
 */
public class FactoryDataException extends FactoryException {
    /**
     * Serial number for inter-operability with different versions.
     */
    private static final long serialVersionUID = -6296443455120500463L;

    /**
     * Construct an exception with no detail message.
     */
    public FactoryDataException() {
    }

    /**
     * Construct an exception with the specified detail message.
     *
     * @param  message  the detail message, saved for later retrieval by the {@link #getMessage()} method.
     */
    public FactoryDataException(String message) {
        super(message);
    }

    /**
     * Constructs an exception with the specified cause.
     *
     * @param cause  the cause, saved for later retrieval by the {@link #getCause()} method.
     *
     * @since 1.2
     */
    public FactoryDataException(Throwable cause) {
        super(cause);
    }

    /**
     * Construct an exception with the specified detail message and cause.
     *
     * @param  message  the detail message, saved for later retrieval by the {@link #getMessage()} method.
     * @param  cause    the cause for this exception, saved for later retrieval by the {@link #getCause()} method.
     */
    public FactoryDataException(String message, Throwable cause) {
        super(message, cause);
    }
}
