/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.calendar;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.calendar.BusinessCalendar;
import org.flowable.common.engine.impl.context.Context;

public class DefaultBusinessCalendar
implements BusinessCalendar {
    private static Map<String, Integer> units = new HashMap<String, Integer>();

    @Override
    public Date resolveDuedate(String duedateDescription, int maxIterations) {
        return this.resolveDuedate(duedateDescription);
    }

    @Override
    public Date resolveDuedate(String duedate) {
        String[] tokens;
        Date resolvedDuedate = Context.getCommandContext().getClock().getCurrentTime();
        for (String token : tokens = duedate.split(" and ")) {
            resolvedDuedate = this.addSingleUnitQuantity(resolvedDuedate, token);
        }
        return resolvedDuedate;
    }

    @Override
    public Boolean validateDuedate(String duedateDescription, int maxIterations, Date endDate, Date newTimer) {
        return true;
    }

    @Override
    public Date resolveEndDate(String endDate) {
        return null;
    }

    protected Date addSingleUnitQuantity(Date startDate, String singleUnitQuantity) {
        int spaceIndex = singleUnitQuantity.indexOf(32);
        if (spaceIndex == -1 || singleUnitQuantity.length() < spaceIndex + 1) {
            throw new FlowableIllegalArgumentException("invalid duedate format: " + singleUnitQuantity);
        }
        String quantityText = singleUnitQuantity.substring(0, spaceIndex);
        int quantity = Integer.parseInt(quantityText);
        String unitText = singleUnitQuantity.substring(spaceIndex + 1).trim().toLowerCase();
        int unit = units.get(unitText);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(startDate);
        calendar.add(unit, quantity);
        return calendar.getTime();
    }

    static {
        units.put("millis", 14);
        units.put("seconds", 13);
        units.put("second", 13);
        units.put("minute", 12);
        units.put("minutes", 12);
        units.put("hour", 10);
        units.put("hours", 10);
        units.put("day", 6);
        units.put("days", 6);
        units.put("week", 3);
        units.put("weeks", 3);
        units.put("month", 2);
        units.put("months", 2);
        units.put("year", 1);
        units.put("years", 1);
    }
}

