/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.discovery.details;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.framework.recipes.cache.CuratorCache;
import org.apache.curator.framework.recipes.cache.CuratorCacheBridge;
import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.apache.curator.shaded.com.google.common.collect.ImmutableList;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.curator.utils.CloseableUtils;
import org.apache.curator.utils.ExceptionAccumulator;
import org.apache.curator.utils.ThreadUtils;
import org.apache.curator.utils.ZKPaths;
import org.apache.curator.x.discovery.DiscoveryPathConstructor;
import org.apache.curator.x.discovery.ServiceCache;
import org.apache.curator.x.discovery.ServiceCacheBuilder;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.ServiceProvider;
import org.apache.curator.x.discovery.ServiceProviderBuilder;
import org.apache.curator.x.discovery.details.DiscoveryPathConstructorImpl;
import org.apache.curator.x.discovery.details.InstanceSerializer;
import org.apache.curator.x.discovery.details.ServiceCacheBuilderImpl;
import org.apache.curator.x.discovery.details.ServiceProviderBuilderImpl;
import org.apache.curator.x.discovery.strategies.RoundRobinStrategy;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceDiscoveryImpl<T>
implements ServiceDiscovery<T> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFramework client;
    private final DiscoveryPathConstructor pathConstructor;
    private final InstanceSerializer<T> serializer;
    private final ConcurrentMap<String, Entry<T>> services = new ConcurrentHashMap<String, Entry<T>>();
    private final Collection<ServiceCache<T>> caches = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Collection<ServiceProvider<T>> providers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final boolean watchInstances;
    private final ConnectionStateListener connectionStateListener = new ConnectionStateListener(){

        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            if (newState == ConnectionState.RECONNECTED || newState == ConnectionState.CONNECTED) {
                try {
                    ServiceDiscoveryImpl.this.log.debug("Re-registering due to reconnection");
                    ServiceDiscoveryImpl.this.reRegisterServices();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    ServiceDiscoveryImpl.this.log.error("Could not re-register instances after reconnection", (Throwable)e);
                }
            }
        }
    };

    public ServiceDiscoveryImpl(CuratorFramework client, String basePath, InstanceSerializer<T> serializer, ServiceInstance<T> thisInstance, boolean watchInstances) {
        this(client, new DiscoveryPathConstructorImpl(basePath), serializer, thisInstance, watchInstances);
    }

    public ServiceDiscoveryImpl(CuratorFramework client, DiscoveryPathConstructor pathConstructor, InstanceSerializer<T> serializer, ServiceInstance<T> thisInstance, boolean watchInstances) {
        this.watchInstances = watchInstances;
        this.client = (CuratorFramework)Preconditions.checkNotNull((Object)client, (Object)"client cannot be null");
        this.pathConstructor = (DiscoveryPathConstructor)Preconditions.checkNotNull((Object)pathConstructor, (Object)"pathConstructor cannot be null");
        this.serializer = (InstanceSerializer)Preconditions.checkNotNull(serializer, (Object)"serializer cannot be null");
        if (thisInstance != null) {
            Entry entry = new Entry(thisInstance);
            entry.cache = this.makeNodeCache(thisInstance);
            this.services.put(thisInstance.getId(), entry);
        }
    }

    @Override
    public void start() throws Exception {
        try {
            this.reRegisterServices();
        }
        catch (KeeperException e) {
            this.log.error("Could not register instances - will try again later", (Throwable)e);
        }
        this.client.getConnectionStateListenable().addListener((Object)this.connectionStateListener);
    }

    @Override
    public void close() throws IOException {
        ExceptionAccumulator accumulator = new ExceptionAccumulator();
        for (ServiceProvider provider : Lists.newArrayList(this.providers)) {
            CloseableUtils.closeQuietly((Closeable)provider);
        }
        for (Entry entry : this.services.values()) {
            try {
                this.internalUnregisterService(entry);
            }
            catch (KeeperException.NoNodeException noNodeException) {
            }
            catch (Exception e) {
                accumulator.add((Throwable)e);
                this.log.error("Could not unregister instance: " + entry.service.getName(), (Throwable)e);
            }
        }
        this.client.getConnectionStateListenable().removeListener((Object)this.connectionStateListener);
        accumulator.propagate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerService(ServiceInstance<T> service) throws Exception {
        Entry useEntry;
        Entry newEntry = new Entry(service);
        Entry oldEntry = this.services.putIfAbsent(service.getId(), newEntry);
        Entry entry = useEntry = oldEntry != null ? oldEntry : newEntry;
        synchronized (entry) {
            if (useEntry == newEntry) {
                useEntry.cache = this.makeNodeCache(service);
            }
            this.internalRegisterService(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateService(ServiceInstance<T> service) throws Exception {
        Entry entry = (Entry)this.services.get(service.getId());
        if (entry == null) {
            throw new Exception("Service not registered: " + service);
        }
        Entry entry2 = entry;
        synchronized (entry2) {
            entry.service = service;
            byte[] bytes = this.serializer.serialize(service);
            String path = this.pathForInstance(service.getName(), service.getId());
            this.client.setData().forPath(path, bytes);
        }
    }

    @VisibleForTesting
    protected void internalRegisterService(ServiceInstance<T> service) throws Exception {
        byte[] bytes = this.serializer.serialize(service);
        String path = this.pathForInstance(service.getName(), service.getId());
        int MAX_TRIES = 2;
        boolean isDone = false;
        for (int i = 0; !isDone && i < 2; ++i) {
            try {
                CreateMode mode;
                switch (service.getServiceType()) {
                    case DYNAMIC: {
                        mode = CreateMode.EPHEMERAL;
                        break;
                    }
                    case DYNAMIC_SEQUENTIAL: {
                        mode = CreateMode.EPHEMERAL_SEQUENTIAL;
                        break;
                    }
                    default: {
                        mode = CreateMode.PERSISTENT;
                    }
                }
                ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentContainersIfNeeded().withMode(mode)).forPath(path, bytes);
                isDone = true;
                continue;
            }
            catch (KeeperException.NodeExistsException e) {
                this.client.delete().forPath(path);
            }
        }
    }

    @Override
    public void unregisterService(ServiceInstance<T> service) throws Exception {
        Entry entry = (Entry)this.services.remove(service.getId());
        this.internalUnregisterService(entry);
    }

    @Override
    public ServiceProviderBuilder<T> serviceProviderBuilder() {
        return new ServiceProviderBuilderImpl(this).providerStrategy(new RoundRobinStrategy()).threadFactory(ThreadUtils.newThreadFactory((String)"ServiceProvider"));
    }

    @Override
    public ServiceCacheBuilder<T> serviceCacheBuilder() {
        return new ServiceCacheBuilderImpl(this);
    }

    @Override
    public Collection<String> queryForNames() throws Exception {
        List names = (List)this.client.getChildren().forPath(this.pathConstructor.getBasePath());
        return ImmutableList.copyOf((Collection)names);
    }

    @Override
    public Collection<ServiceInstance<T>> queryForInstances(String name) throws Exception {
        return this.queryForInstances(name, null);
    }

    @Override
    public ServiceInstance<T> queryForInstance(String name, String id) throws Exception {
        String path = this.pathForInstance(name, id);
        try {
            byte[] bytes = (byte[])this.client.getData().forPath(path);
            return this.serializer.deserialize(bytes);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            return null;
        }
    }

    void cacheOpened(ServiceCache<T> cache) {
        this.caches.add(cache);
    }

    void cacheClosed(ServiceCache<T> cache) {
        this.caches.remove(cache);
    }

    void providerOpened(ServiceProvider<T> provider) {
        this.providers.add(provider);
    }

    void providerClosed(ServiceProvider<T> cache) {
        this.providers.remove(cache);
    }

    CuratorFramework getClient() {
        return this.client;
    }

    String pathForName(String serviceName) {
        return this.pathConstructor.getPathForInstances(serviceName);
    }

    InstanceSerializer<T> getSerializer() {
        return this.serializer;
    }

    List<ServiceInstance<T>> queryForInstances(String name, Watcher watcher) throws Exception {
        List<Object> instanceIds;
        ImmutableList.Builder builder = ImmutableList.builder();
        String path = this.pathForName(name);
        if (watcher != null) {
            instanceIds = this.getChildrenWatched(path, watcher, true);
        } else {
            try {
                instanceIds = (List)this.client.getChildren().forPath(path);
            }
            catch (KeeperException.NoNodeException e) {
                instanceIds = Lists.newArrayList();
            }
        }
        for (String string : instanceIds) {
            ServiceInstance<T> instance = this.queryForInstance(name, string);
            if (instance == null) continue;
            builder.add(instance);
        }
        return builder.build();
    }

    @VisibleForTesting
    int debugServicesQty() {
        return this.services.size();
    }

    private List<String> getChildrenWatched(String path, Watcher watcher, boolean recurse) throws Exception {
        List<String> instanceIds;
        try {
            instanceIds = (List<String>)((BackgroundPathable)this.client.getChildren().usingWatcher(watcher)).forPath(path);
        }
        catch (KeeperException.NoNodeException e) {
            if (recurse) {
                try {
                    this.client.create().creatingParentContainersIfNeeded().forPath(path);
                }
                catch (KeeperException.NodeExistsException nodeExistsException) {
                    // empty catch block
                }
                instanceIds = this.getChildrenWatched(path, watcher, false);
            }
            throw e;
        }
        return instanceIds;
    }

    @VisibleForTesting
    String pathForInstance(String serviceName, String instanceId) {
        return ZKPaths.makePath((String)this.pathForName(serviceName), (String)instanceId);
    }

    @VisibleForTesting
    ServiceInstance<T> getRegisteredService(String id) {
        Entry entry = (Entry)this.services.get(id);
        return entry != null ? entry.service : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reRegisterServices() throws Exception {
        Iterator iterator = this.services.values().iterator();
        while (iterator.hasNext()) {
            Entry entry;
            Entry entry2 = entry = (Entry)iterator.next();
            synchronized (entry2) {
                this.internalRegisterService(entry.service);
            }
        }
    }

    private CuratorCacheBridge makeNodeCache(ServiceInstance<T> instance) {
        if (!this.watchInstances) {
            return null;
        }
        CuratorCacheBridge cache = CuratorCache.bridgeBuilder((CuratorFramework)this.client, (String)this.pathForInstance(instance.getName(), instance.getId())).withOptions(new CuratorCache.Options[]{CuratorCache.Options.SINGLE_NODE_CACHE}).withDataNotCached().build();
        CuratorCacheListener listener = CuratorCacheListener.builder().afterInitialized().forAll((__, ___, data) -> {
            block7: {
                if (data != null) {
                    try {
                        ServiceInstance<T> newInstance = this.serializer.deserialize(data.getData());
                        Entry entry = (Entry)this.services.get(newInstance.getId());
                        if (entry == null) break block7;
                        Entry entry2 = entry;
                        synchronized (entry2) {
                            entry.service = newInstance;
                        }
                    }
                    catch (Exception e) {
                        this.log.debug("Could not deserialize: " + data.getPath());
                    }
                } else {
                    this.log.warn("Instance data has been deleted for: " + instance);
                }
            }
        }).build();
        cache.listenable().addListener((Object)listener);
        cache.start();
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalUnregisterService(Entry<T> entry) throws Exception {
        if (entry != null) {
            Entry<T> entry2 = entry;
            synchronized (entry2) {
                if (((Entry)entry).cache != null) {
                    CloseableUtils.closeQuietly((Closeable)((Entry)entry).cache);
                    ((Entry)entry).cache = null;
                }
                String path = this.pathForInstance(((Entry)entry).service.getName(), ((Entry)entry).service.getId());
                try {
                    ((ChildrenDeletable)this.client.delete().guaranteed()).forPath(path);
                }
                catch (KeeperException.NoNodeException noNodeException) {
                    // empty catch block
                }
            }
        }
    }

    private static class Entry<T> {
        private volatile ServiceInstance<T> service;
        private volatile CuratorCacheBridge cache;

        private Entry(ServiceInstance<T> service) {
            this.service = service;
        }
    }
}

