/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.ds;

import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.ds.Filter;
import com.okta.sdk.impl.ds.FilterChain;
import com.okta.sdk.impl.ds.ResourceDataRequest;
import com.okta.sdk.impl.ds.ResourceDataResult;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFilterChain
implements FilterChain {
    private static final Logger log = LoggerFactory.getLogger(DefaultFilterChain.class);
    private final List<Filter> filters;
    private int index = 0;
    private final FilterChain completionHandler;

    public DefaultFilterChain(List<Filter> filters, FilterChain completionHandler) {
        this.filters = filters;
        Assert.notNull((Object)completionHandler, (String)"completionHandler cannot be null.");
        this.completionHandler = completionHandler;
    }

    @Override
    public ResourceDataResult filter(ResourceDataRequest request) {
        if (this.filters == null || this.filters.size() == this.index) {
            if (log.isTraceEnabled()) {
                log.trace("Invoking completion handler.");
            }
            return this.completionHandler.filter(request);
        }
        if (log.isTraceEnabled()) {
            log.trace("Invoking wrapped filter at index [" + this.index + "]");
        }
        return this.filters.get(this.index++).filter(request, this);
    }
}

