/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.List;
import java.util.Optional;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.syncope.core.persistence.api.dao.AuthProfileDAO;
import org.apache.syncope.core.persistence.api.entity.am.AuthProfile;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.am.JPAAuthProfile;

public class JPAAuthProfileDAO
extends AbstractDAO<AuthProfile>
implements AuthProfileDAO {
    public AuthProfile find(String key) {
        return (AuthProfile)this.entityManager().find(JPAAuthProfile.class, (Object)key);
    }

    public int count() {
        Query query = this.entityManager().createQuery("SELECT COUNT(e) FROM  " + JPAAuthProfile.class.getSimpleName() + " e");
        return ((Number)query.getSingleResult()).intValue();
    }

    public List<AuthProfile> findAll(int page, int itemsPerPage) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAAuthProfile.class.getSimpleName() + " e ORDER BY e.owner ASC", AuthProfile.class);
        query.setFirstResult(itemsPerPage * (page <= 0 ? 0 : page - 1));
        if (itemsPerPage >= 0) {
            query.setMaxResults(itemsPerPage);
        }
        return query.getResultList();
    }

    public Optional<AuthProfile> findByOwner(String owner) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAAuthProfile.class.getSimpleName() + " e WHERE e.owner=:owner", AuthProfile.class);
        query.setParameter("owner", (Object)owner);
        List result = query.getResultList();
        return result.isEmpty() ? Optional.empty() : Optional.of((AuthProfile)result.get(0));
    }

    public AuthProfile save(AuthProfile profile) {
        return (AuthProfile)this.entityManager().merge((Object)profile);
    }

    public void delete(String key) {
        AuthProfile authProfile = this.find(key);
        if (authProfile == null) {
            return;
        }
        this.delete(authProfile);
    }

    public void delete(AuthProfile authProfile) {
        this.entityManager().remove((Object)authProfile);
    }
}

