/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserRequest;
import org.apache.syncope.common.lib.to.UserRequestForm;
import org.apache.syncope.common.lib.to.WorkflowTaskExecInput;
import org.apache.syncope.common.rest.api.beans.UserRequestQuery;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Tag(name="Flowable")
@SecurityRequirements(value={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
@Path(value="flowable/userRequests")
public interface UserRequestService
extends JAXRSService {
    @GET
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public PagedResult<UserRequest> listRequests(@BeanParam UserRequestQuery var1);

    @POST
    @Path(value="start/{bpmnProcess}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    public UserRequest startRequest(@NotNull @PathParam(value="bpmnProcess") String var1, @QueryParam(value="user") String var2, WorkflowTaskExecInput var3);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @DELETE
    @Path(value="{executionId}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void cancelRequest(@NotNull @PathParam(value="executionId") String var1, @QueryParam(value="reason") String var2);

    @GET
    @Path(value="forms/{username}/{taskId}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public UserRequestForm getForm(@NotNull @PathParam(value="username") String var1, @NotNull @PathParam(value="taskId") String var2);

    @GET
    @Path(value="forms")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public PagedResult<UserRequestForm> listForms(@BeanParam UserRequestQuery var1);

    @POST
    @Path(value="forms/{taskId}/claim")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public UserRequestForm claimForm(@NotNull @PathParam(value="taskId") String var1);

    @POST
    @Path(value="forms/{taskId}/unclaim")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public UserRequestForm unclaimForm(@NotNull @PathParam(value="taskId") String var1);

    @Parameters(value={@Parameter(name="Prefer", in=ParameterIn.HEADER, description="Allows client to specify a preference for the result to be returned from the server", allowEmptyValue=true, schema=@Schema(defaultValue="return-content", allowableValues={"return-content", "return-no-content"})), @Parameter(name="X-Syncope-Null-Priority-Async", in=ParameterIn.HEADER, description="If 'true', instructs the propagation process not to wait for completion when communicating with External Resources with no priority set", allowEmptyValue=true, schema=@Schema(type="boolean", defaultValue="false"))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User successfully updated enriched with propagation status information, as Entity", content={@Content(schema=@Schema(implementation=ProvisioningResult.class))}), @ApiResponse(responseCode="204", description="No content if 'Prefer: return-no-content' was specified", headers={@Header(name="Preference-Applied", schema=@Schema(type="string"), description="Allows the server to inform the client about the fact that a specified preference was applied")})})
    @POST
    @Path(value="forms")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    public Response submitForm(@NotNull UserRequestForm var1);
}

