/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.logging.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.jdbc.BaseJdbcLogger;
import org.apache.ibatis.logging.jdbc.ResultSetLogger;
import org.apache.ibatis.reflection.ExceptionUtil;

public final class StatementLogger
extends BaseJdbcLogger
implements InvocationHandler {
    private final Statement statement;

    private StatementLogger(Statement stmt, Log statementLog, int queryStack) {
        super(statementLog, queryStack);
        this.statement = stmt;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] params) throws Throwable {
        try {
            if (Object.class.equals(method.getDeclaringClass())) {
                return method.invoke((Object)this, params);
            }
            if (EXECUTE_METHODS.contains(method.getName())) {
                if (this.isDebugEnabled()) {
                    this.debug(" Executing: " + this.removeExtraWhitespace((String)params[0]), true);
                }
                if ("executeQuery".equals(method.getName())) {
                    ResultSet rs = (ResultSet)method.invoke((Object)this.statement, params);
                    return rs == null ? null : ResultSetLogger.newInstance(rs, this.statementLog, this.queryStack);
                }
                return method.invoke((Object)this.statement, params);
            }
            if ("getResultSet".equals(method.getName())) {
                ResultSet rs = (ResultSet)method.invoke((Object)this.statement, params);
                return rs == null ? null : ResultSetLogger.newInstance(rs, this.statementLog, this.queryStack);
            }
            return method.invoke((Object)this.statement, params);
        }
        catch (Throwable t) {
            throw ExceptionUtil.unwrapThrowable(t);
        }
    }

    public static Statement newInstance(Statement stmt, Log statementLog, int queryStack) {
        StatementLogger handler = new StatementLogger(stmt, statementLog, queryStack);
        ClassLoader cl = Statement.class.getClassLoader();
        return (Statement)Proxy.newProxyInstance(cl, new Class[]{Statement.class}, (InvocationHandler)handler);
    }

    public Statement getStatement() {
        return this.statement;
    }
}

