/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.recipe;

import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.xbean.propertyeditor.PropertyEditorRegistry;
import org.apache.xbean.recipe.AbstractRecipe;
import org.apache.xbean.recipe.ConstructionException;
import org.apache.xbean.recipe.ExecutionContext;
import org.apache.xbean.recipe.Option;
import org.apache.xbean.recipe.Recipe;
import org.apache.xbean.recipe.RecipeHelper;
import org.apache.xbean.recipe.Reference;

public class MapRecipe
extends AbstractRecipe {
    private final List<Object[]> entries;
    private String typeName;
    private Class typeClass;
    private PropertyEditorRegistry registry;
    private final EnumSet<Option> options = EnumSet.noneOf(Option.class);

    public MapRecipe() {
        this.entries = new ArrayList<Object[]>();
    }

    public MapRecipe(String type) {
        this.typeName = type;
        this.entries = new ArrayList<Object[]>();
    }

    public MapRecipe(Class type) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        this.typeClass = type;
        this.entries = new ArrayList<Object[]>();
    }

    public MapRecipe(Map<?, ?> map) {
        if (map == null) {
            throw new NullPointerException("map is null");
        }
        this.entries = new ArrayList<Object[]>(map.size());
        this.typeClass = RecipeHelper.hasDefaultConstructor(map.getClass()) ? map.getClass() : (map instanceof SortedMap ? TreeMap.class : (map instanceof ConcurrentMap ? ConcurrentHashMap.class : LinkedHashMap.class));
        this.putAll(map);
    }

    public MapRecipe(MapRecipe mapRecipe) {
        if (mapRecipe == null) {
            throw new NullPointerException("mapRecipe is null");
        }
        this.typeName = mapRecipe.typeName;
        this.typeClass = mapRecipe.typeClass;
        this.entries = new ArrayList<Object[]>(mapRecipe.entries);
    }

    public void setRegistry(PropertyEditorRegistry registry) {
        this.registry = registry;
    }

    public void allow(Option option) {
        this.options.add(option);
    }

    public void disallow(Option option) {
        this.options.remove((Object)option);
    }

    @Override
    public List<Recipe> getNestedRecipes() {
        ArrayList<Recipe> nestedRecipes = new ArrayList<Recipe>(this.entries.size() * 2);
        for (Object[] entry : this.entries) {
            Object value;
            Object key = entry[0];
            if (key instanceof Recipe) {
                Recipe recipe = (Recipe)key;
                nestedRecipes.add(recipe);
            }
            if (!((value = entry[1]) instanceof Recipe)) continue;
            Recipe recipe = (Recipe)value;
            nestedRecipes.add(recipe);
        }
        return nestedRecipes;
    }

    @Override
    public List<Recipe> getConstructorRecipes() {
        if (!this.options.contains((Object)Option.LAZY_ASSIGNMENT)) {
            return this.getNestedRecipes();
        }
        return Collections.emptyList();
    }

    @Override
    public boolean canCreate(Type type) {
        Class myType = this.getType(type);
        return RecipeHelper.isAssignable(type, myType);
    }

    @Override
    protected Object internalCreate(Type expectedType, boolean lazyRefAllowed) throws ConstructionException {
        Map instance;
        Object o;
        Class mapType = this.getType(expectedType);
        if (!RecipeHelper.hasDefaultConstructor(mapType)) {
            throw new ConstructionException("Type does not have a default constructor " + mapType.getName());
        }
        try {
            o = mapType.newInstance();
        }
        catch (Exception e) {
            throw new ConstructionException("Error while creating set instance: " + mapType.getName());
        }
        if (o instanceof Map) {
            instance = (Map)o;
        } else if (o instanceof Dictionary) {
            instance = new DummyDictionaryAsMap((Dictionary)o);
        } else {
            throw new ConstructionException("Specified map type does not implement the Map interface: " + mapType.getName());
        }
        Object keyType = Object.class;
        Object valueType = Object.class;
        Type[] typeParameters = RecipeHelper.getTypeParameters(Map.class, expectedType);
        if (typeParameters != null && typeParameters.length == 2) {
            if (typeParameters[0] instanceof Class) {
                keyType = typeParameters[0];
            }
            if (typeParameters[1] instanceof Class) {
                valueType = typeParameters[1];
            }
        }
        if (this.getName() != null) {
            ExecutionContext.getContext().addObject(this.getName(), instance);
        }
        boolean refAllowed = this.options.contains((Object)Option.LAZY_ASSIGNMENT);
        for (Object[] entry : this.entries) {
            Reference.Action action;
            Object key = RecipeHelper.convert((Type)keyType, entry[0], refAllowed, this.registry);
            Object value = RecipeHelper.convert((Type)valueType, entry[1], refAllowed, this.registry);
            if (key instanceof Reference) {
                action = new UpdateMap(instance, key, value);
                ((Reference)key).setAction(action);
                if (!(value instanceof Reference)) continue;
                ((Reference)value).setAction(action);
                continue;
            }
            if (value instanceof Reference) {
                instance.put(key, null);
                action = new UpdateValue(instance, key);
                ((Reference)value).setAction(action);
                continue;
            }
            instance.put(key, value);
        }
        return instance;
    }

    private Class getType(Type expectedType) {
        Class expectedClass = RecipeHelper.toClass(expectedType);
        if (this.typeClass != null || this.typeName != null) {
            Class type = this.typeClass;
            if (type == null) {
                try {
                    type = RecipeHelper.loadClass(this.typeName);
                }
                catch (ClassNotFoundException e) {
                    throw new ConstructionException("Type class could not be found: " + this.typeName);
                }
            }
            if (type.isAssignableFrom(expectedClass)) {
                return this.getMap(expectedClass);
            }
            return this.getMap(type);
        }
        return this.getMap(expectedClass);
    }

    private Class getMap(Class type) {
        if (RecipeHelper.hasDefaultConstructor(type)) {
            return type;
        }
        if (SortedMap.class.isAssignableFrom(type)) {
            return TreeMap.class;
        }
        if (ConcurrentMap.class.isAssignableFrom(type)) {
            return ConcurrentHashMap.class;
        }
        return LinkedHashMap.class;
    }

    public void put(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        this.entries.add(new Object[]{key, value});
    }

    public void putAll(Map<?, ?> map) {
        if (map == null) {
            throw new NullPointerException("map is null");
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            this.put(key, value);
        }
    }

    public static class DummyDictionaryAsMap
    extends AbstractMap {
        private final Dictionary dictionary;

        public DummyDictionaryAsMap(Dictionary dictionary) {
            this.dictionary = dictionary;
        }

        @Override
        public Object put(Object key, Object value) {
            return this.dictionary.put(key, value);
        }

        @Override
        public Set entrySet() {
            throw new UnsupportedOperationException();
        }
    }

    private static class UpdateMap
    implements Reference.Action {
        private final Map map;
        private final Object key;
        private final Object value;

        public UpdateMap(Map map, Object key, Object value) {
            this.map = map;
            this.key = key;
            this.value = value;
        }

        @Override
        public void onSet(Reference ignored) {
            Object value;
            Object key = this.key;
            if (key instanceof Reference) {
                Reference reference = (Reference)key;
                if (!reference.isResolved()) {
                    return;
                }
                key = reference.get();
            }
            if ((value = this.value) instanceof Reference) {
                Reference reference = (Reference)value;
                if (!reference.isResolved()) {
                    return;
                }
                value = reference.get();
            }
            this.map.put(key, value);
        }
    }

    private static class UpdateValue
    implements Reference.Action {
        private final Map map;
        private final Object key;

        public UpdateValue(Map map, Object key) {
            this.map = map;
            this.key = key;
        }

        @Override
        public void onSet(Reference ref) {
            this.map.put(this.key, ref.get());
        }
    }
}

