/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.stream;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CountingOutputStream
extends FilterOutputStream {
    private int count = 0;

    public CountingOutputStream(OutputStream rawIn) {
        super(rawIn);
    }

    @Override
    public void write(int b) throws IOException {
        ++this.count;
        super.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.count += b.length;
        super.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.count += len;
        super.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public int getCount() {
        return this.count;
    }
}

