/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.ds.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.inventory.Format;
import org.apache.felix.inventory.InventoryPrinter;
import org.apache.felix.webconsole.SimpleWebConsolePlugin;
import org.apache.felix.webconsole.bundleinfo.BundleInfoProvider;
import org.apache.felix.webconsole.plugins.ds.internal.ComponentConfigurationPrinter;
import org.apache.felix.webconsole.plugins.ds.internal.InfoProvider;
import org.apache.felix.webconsole.plugins.ds.internal.WebConsolePlugin;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator,
ServiceTrackerCustomizer<ServiceComponentRuntime, ServiceComponentRuntime> {
    private ServiceTracker<ServiceComponentRuntime, ServiceComponentRuntime> tracker;
    private BundleContext context;
    private SimpleWebConsolePlugin plugin;
    private ServiceRegistration<InventoryPrinter> printerRegistration;
    private ServiceRegistration<BundleInfoProvider> infoRegistration;

    public final void start(BundleContext context) throws Exception {
        this.context = context;
        this.tracker = new ServiceTracker(context, ServiceComponentRuntime.class, (ServiceTrackerCustomizer)this);
        this.tracker.open();
    }

    public final void stop(BundleContext context) throws Exception {
        if (this.tracker != null) {
            this.tracker.close();
            this.tracker = null;
        }
    }

    public final void modifiedService(ServiceReference<ServiceComponentRuntime> reference, ServiceComponentRuntime service) {
    }

    public final ServiceComponentRuntime addingService(ServiceReference<ServiceComponentRuntime> reference) {
        SimpleWebConsolePlugin plugin = this.plugin;
        if (plugin == null) {
            ServiceComponentRuntime service = (ServiceComponentRuntime)this.context.getService(reference);
            this.plugin = plugin = new WebConsolePlugin(service).register(this.context);
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            String name = "Declarative Services Components";
            ((Dictionary)props).put("felix.inventory.printer.name", "scr");
            ((Dictionary)props).put("felix.inventory.printer.title", "Declarative Services Components");
            ((Dictionary)props).put("felix.inventory.printer.format", new String[]{Format.TEXT.toString(), Format.JSON.toString()});
            this.printerRegistration = this.context.registerService(InventoryPrinter.class, (Object)new ComponentConfigurationPrinter(service, (WebConsolePlugin)plugin), props);
            this.infoRegistration = new InfoProvider(this.context.getBundle(), service).register(this.context);
        }
        return (ServiceComponentRuntime)this.context.getService(reference);
    }

    public final void removedService(ServiceReference<ServiceComponentRuntime> reference, ServiceComponentRuntime service) {
        SimpleWebConsolePlugin plugin = this.plugin;
        if (this.tracker.getTrackingCount() == 0 && plugin != null) {
            plugin.unregister();
            this.plugin = null;
            ServiceRegistration<InventoryPrinter> reg = this.printerRegistration;
            if (reg != null) {
                reg.unregister();
                this.printerRegistration = null;
            }
            if ((reg = this.infoRegistration) != null) {
                reg.unregister();
                this.infoRegistration = null;
            }
        }
    }
}

