/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.kafka.clients.ConnectionState;

final class ClusterConnectionStates {
    private final long reconnectBackoffInitMs;
    private final long reconnectBackoffMaxMs;
    private static final int RECONNECT_BACKOFF_EXP_BASE = 2;
    private final double reconnectBackoffMaxExp;
    private final Map<String, NodeConnectionState> nodeState;

    public ClusterConnectionStates(long reconnectBackoffMs, long reconnectBackoffMaxMs) {
        this.reconnectBackoffInitMs = reconnectBackoffMs;
        this.reconnectBackoffMaxMs = reconnectBackoffMaxMs;
        this.reconnectBackoffMaxExp = Math.log((double)this.reconnectBackoffMaxMs / (double)Math.max(reconnectBackoffMs, 1L)) / Math.log(2.0);
        this.nodeState = new HashMap<String, NodeConnectionState>();
    }

    public boolean canConnect(String id, long now) {
        NodeConnectionState state = this.nodeState.get(id);
        if (state == null) {
            return true;
        }
        return state.state == ConnectionState.DISCONNECTED && now - state.lastConnectAttemptMs >= state.reconnectBackoffMs;
    }

    public boolean isBlackedOut(String id, long now) {
        NodeConnectionState state = this.nodeState.get(id);
        if (state == null) {
            return false;
        }
        return state.state == ConnectionState.DISCONNECTED && now - state.lastConnectAttemptMs < state.reconnectBackoffMs;
    }

    public long connectionDelay(String id, long now) {
        NodeConnectionState state = this.nodeState.get(id);
        if (state == null) {
            return 0L;
        }
        long timeWaited = now - state.lastConnectAttemptMs;
        if (state.state == ConnectionState.DISCONNECTED) {
            return Math.max(state.reconnectBackoffMs - timeWaited, 0L);
        }
        return Long.MAX_VALUE;
    }

    public boolean isConnecting(String id) {
        NodeConnectionState state = this.nodeState.get(id);
        return state != null && state.state == ConnectionState.CONNECTING;
    }

    public void connecting(String id, long now) {
        this.nodeState.put(id, new NodeConnectionState(ConnectionState.CONNECTING, now, this.reconnectBackoffInitMs));
    }

    public void disconnected(String id, long now) {
        NodeConnectionState nodeState = this.nodeState(id);
        nodeState.state = ConnectionState.DISCONNECTED;
        nodeState.lastConnectAttemptMs = now;
        this.updateReconnectBackoff(nodeState);
    }

    public void checkingApiVersions(String id) {
        NodeConnectionState nodeState = this.nodeState(id);
        nodeState.state = ConnectionState.CHECKING_API_VERSIONS;
    }

    public void ready(String id) {
        NodeConnectionState nodeState = this.nodeState(id);
        nodeState.state = ConnectionState.READY;
        this.resetReconnectBackoff(nodeState);
    }

    public boolean isReady(String id) {
        NodeConnectionState state = this.nodeState.get(id);
        return state != null && state.state == ConnectionState.READY;
    }

    public boolean hasReadyNodes() {
        for (Map.Entry<String, NodeConnectionState> entry : this.nodeState.entrySet()) {
            NodeConnectionState state = entry.getValue();
            if (state == null || state.state != ConnectionState.READY) continue;
            return true;
        }
        return false;
    }

    public boolean isDisconnected(String id) {
        NodeConnectionState state = this.nodeState.get(id);
        return state != null && state.state == ConnectionState.DISCONNECTED;
    }

    public void resetReconnectBackoff(NodeConnectionState nodeState) {
        nodeState.failedAttempts = 0L;
        nodeState.reconnectBackoffMs = this.reconnectBackoffInitMs;
    }

    public void updateReconnectBackoff(NodeConnectionState nodeState) {
        if (this.reconnectBackoffMaxMs > this.reconnectBackoffInitMs) {
            ++nodeState.failedAttempts;
            double backoffExp = Math.min((double)(nodeState.failedAttempts - 1L), this.reconnectBackoffMaxExp);
            double backoffFactor = Math.pow(2.0, backoffExp);
            long reconnectBackoffMs = (long)((double)this.reconnectBackoffInitMs * backoffFactor);
            double randomFactor = ThreadLocalRandom.current().nextDouble(0.8, 1.2);
            nodeState.reconnectBackoffMs = (long)(randomFactor * (double)reconnectBackoffMs);
        }
    }

    public void remove(String id) {
        this.nodeState.remove(id);
    }

    public ConnectionState connectionState(String id) {
        return this.nodeState((String)id).state;
    }

    private NodeConnectionState nodeState(String id) {
        NodeConnectionState state = this.nodeState.get(id);
        if (state == null) {
            throw new IllegalStateException("No entry found for connection " + id);
        }
        return state;
    }

    private static class NodeConnectionState {
        ConnectionState state;
        long lastConnectAttemptMs;
        long failedAttempts;
        long reconnectBackoffMs;

        public NodeConnectionState(ConnectionState state, long lastConnectAttempt, long reconnectBackoffMs) {
            this.state = state;
            this.lastConnectAttemptMs = lastConnectAttempt;
            this.failedAttempts = 0L;
            this.reconnectBackoffMs = reconnectBackoffMs;
        }

        public String toString() {
            return "NodeState(" + (Object)((Object)this.state) + ", " + this.lastConnectAttemptMs + ")";
        }
    }
}

