/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.DelegateProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.RouteNode;
import org.apache.camel.Traceable;
import org.apache.camel.model.ProcessorDefinition;

public class DefaultRouteNode
implements RouteNode {
    private Expression expression;
    private Processor processor;
    private ProcessorDefinition<?> processorDefinition;

    public DefaultRouteNode(ProcessorDefinition<?> processorDefinition, Processor processor) {
        this.processor = processor;
        this.processorDefinition = processorDefinition;
    }

    public DefaultRouteNode(ProcessorDefinition<?> processorDefinition, Expression expression) {
        this.processorDefinition = processorDefinition;
        this.expression = expression;
    }

    @Override
    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    public ProcessorDefinition<?> getProcessorDefinition() {
        return this.processorDefinition;
    }

    @Override
    public String getLabel(Exchange exchange) {
        if (this.expression != null) {
            return this.expression.evaluate(exchange, String.class);
        }
        String label = this.getTraceLabel(this.processor);
        if (label == null) {
            label = this.processorDefinition.getLabel();
        }
        return label;
    }

    private String getTraceLabel(Processor target) {
        if (target == null) {
            return null;
        }
        if (target instanceof Traceable) {
            Traceable trace = (Traceable)((Object)target);
            return trace.getTraceLabel();
        }
        if (target instanceof org.apache.camel.processor.Traceable) {
            org.apache.camel.processor.Traceable trace = (org.apache.camel.processor.Traceable)((Object)target);
            return trace.getTraceLabel();
        }
        if (target instanceof DelegateProcessor) {
            return this.getTraceLabel(((DelegateProcessor)target).getProcessor());
        }
        return null;
    }

    @Override
    public boolean isAbstract() {
        return this.processor == null;
    }

    public String toString() {
        return "RouteNode[" + this.processorDefinition + "]";
    }
}

