/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.transformer;

import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.converter.stream.OutputStreamBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Transformer;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFormatTransformer
extends Transformer {
    private static final Logger LOG = LoggerFactory.getLogger(DataFormatTransformer.class);
    private String dataFormatRef;
    private DataFormatDefinition dataFormatType;
    private DataFormat dataFormat;
    private String transformerString;

    public DataFormatTransformer(CamelContext context) {
        this.setCamelContext(context);
    }

    @Override
    public void transform(Message message, DataType from, DataType to) throws Exception {
        Exchange exchange = message.getExchange();
        CamelContext context = exchange.getContext();
        if ((to == null || to.isJavaType()) && (from.equals(this.getFrom()) || from.getModel().equals(this.getModel()))) {
            Class<?> toClass;
            DataFormat dataFormat = this.getDataFormat(exchange);
            LOG.debug("Unmarshaling with '{}'", (Object)dataFormat);
            Object answer = dataFormat.unmarshal(exchange, message.getBody(InputStream.class));
            if (to != null && to.getName() != null && !(toClass = context.getClassResolver().resolveClass(to.getName())).isAssignableFrom(answer.getClass())) {
                LOG.debug("Converting to '{}'", (Object)toClass.getName());
                answer = context.getTypeConverter().mandatoryConvertTo(toClass, answer);
            }
            message.setBody(answer);
        } else if ((from == null || from.isJavaType()) && (to.equals(this.getTo()) || to.getModel().equals(this.getModel()))) {
            Class<?> fromClass;
            Object input = message.getBody();
            if (from != null && from.getName() != null && !(fromClass = context.getClassResolver().resolveClass(from.getName())).isAssignableFrom(input.getClass())) {
                LOG.debug("Converting to '{}'", (Object)fromClass.getName());
                input = context.getTypeConverter().mandatoryConvertTo(fromClass, input);
            }
            OutputStreamBuilder osb = OutputStreamBuilder.withExchange(exchange);
            DataFormat dataFormat = this.getDataFormat(exchange);
            LOG.debug("Marshaling with '{}'", (Object)dataFormat);
            dataFormat.marshal(exchange, message.getBody(), osb);
            message.setBody(osb.build());
        } else {
            throw new IllegalArgumentException("Unsupported transformation: from='" + from + ", to='" + to + "'");
        }
    }

    private DataFormat getDataFormat(Exchange exchange) throws Exception {
        if (this.dataFormat == null) {
            this.dataFormat = DataFormatDefinition.getDataFormat(exchange.getUnitOfWork().getRouteContext(), this.dataFormatType, this.dataFormatRef);
            if (this.dataFormat != null && !this.getCamelContext().hasService(this.dataFormat)) {
                this.getCamelContext().addService(this.dataFormat, false);
            }
        }
        return this.dataFormat;
    }

    public DataFormatTransformer setDataFormatRef(String ref) {
        this.dataFormatRef = ref;
        this.transformerString = null;
        return this;
    }

    public DataFormatTransformer setDataFormatType(DataFormatDefinition dataFormatType) {
        this.dataFormatType = dataFormatType;
        this.transformerString = null;
        return this;
    }

    @Override
    public String toString() {
        if (this.transformerString == null) {
            this.transformerString = String.format("DataFormatTransformer[scheme='%s', from='%s', to='%s', ref='%s', type='%s']", this.getModel(), this.getFrom(), this.getTo(), this.dataFormatRef, this.dataFormatType);
        }
        return this.transformerString;
    }

    @Override
    public void doStart() throws Exception {
    }

    @Override
    public void doStop() throws Exception {
        ServiceHelper.stopService(this.dataFormat);
        this.getCamelContext().removeService(this.dataFormat);
    }
}

