/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.constants;

public enum DNSOptionCode {
    Unknown("Unknown", 65535),
    LLQ("LLQ", 1),
    UL("UL", 2),
    NSID("NSID", 3),
    Owner("Owner", 4);

    private final String externalName;
    private final int indexValue;

    private DNSOptionCode(String name, int index) {
        this.externalName = name;
        this.indexValue = index;
    }

    public String externalName() {
        return this.externalName;
    }

    public int indexValue() {
        return this.indexValue;
    }

    public static DNSOptionCode resultCodeForFlags(int code) {
        for (DNSOptionCode optionCode : DNSOptionCode.values()) {
            if (optionCode.indexValue != code) continue;
            return optionCode;
        }
        return Unknown;
    }

    public String toString() {
        return this.name() + " index " + this.indexValue();
    }
}

