/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.causeway.extensions.fullcalendar.wkt.ui.viewer;

import org.apache.wicket.RestartResponseException;

import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.core.metamodel.context.HasMetaModelContext;
import org.apache.causeway.core.metamodel.object.ProtoObject;
import org.apache.causeway.core.metamodel.objectmanager.ObjectManager;
import org.apache.causeway.core.metamodel.specloader.SpecificationLoader;
import org.apache.causeway.extensions.fullcalendar.wkt.integration.fc.CalendarConfig;
import org.apache.causeway.extensions.fullcalendar.wkt.integration.fc.CalendarResponse;
import org.apache.causeway.extensions.fullcalendar.wkt.integration.fc.FullCalendar;
import org.apache.causeway.extensions.fullcalendar.wkt.integration.fc.callback.ClickedEvent;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;
import org.apache.causeway.viewer.wicket.ui.pages.obj.DomainObjectPage;

import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;

final class FullCalendarWithEventHandling extends FullCalendar
implements HasMetaModelContext {

    private static final long serialVersionUID = 1L;

    @SuppressWarnings("unused")
	private final NotificationPanel feedback;

    FullCalendarWithEventHandling(
            final String id,
            final CalendarConfig config,
            final NotificationPanel feedback) {
        super(id, config);
        this.feedback = feedback;
    }

    @Override
    protected void onEventClicked(
            final ClickedEvent event,
            final CalendarResponse response) {

        final String oidStr = (String) event.getEvent().getPayload();
        final Bookmark bookmark = Bookmark.parse(oidStr).orElse(null);
        if(bookmark==null) return;

        var commonContext = getMetaModelContext();

        final SpecificationLoader specificationLoader = commonContext.getSpecificationLoader();
        final ObjectManager objectManager = commonContext.getObjectManager();

        var managedObject = objectManager
                .loadObject(ProtoObject.resolveElseFail(specificationLoader, bookmark));

        final UiObjectWkt objectModel = UiObjectWkt.ofAdapter(managedObject);

        var pageParameters = objectModel.getPageParameters();
        if(pageParameters!=null) {
            throw new RestartResponseException(DomainObjectPage.class, pageParameters);
        }

        // otherwise ignore
    }

}
