/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.HijrahDate;
import java.time.chrono.JapaneseDate;
import java.time.chrono.MinguoDate;
import java.time.chrono.ThaiBuddhistDate;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.TestClassBuilder;
import org.apache.commons.lang3.stream.IntStreams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class EqualsBuilderReflectJreImplementationTest
extends AbstractLangTest {
    EqualsBuilderReflectJreImplementationTest() {
    }

    @Test
    void testRecursive() {
        MyClass o1 = new MyClass(new MyCharSequence("1"), new MyTemporal("2"), new MyTemporalAccessor("3"), new MyTemporalAmount("4"));
        MyClass o1Bis = new MyClass(new MyCharSequence("1"), new MyTemporal("2"), new MyTemporalAccessor("3"), new MyTemporalAmount("4"));
        MyClass o2 = new MyClass(new MyCharSequence("5"), new MyTemporal("6"), new MyTemporalAccessor("7"), new MyTemporalAmount("8"));
        MyClass o2Bis = new MyClass(new MyCharSequence("5"), new MyTemporal("6"), new MyTemporalAccessor("7"), new MyTemporalAmount("8"));
        Assertions.assertTrue((boolean)new EqualsBuilder().setTestRecursive(true).append((Object)new MyTemporal("1"), (Object)new MyTemporal("1")).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().setTestRecursive(true).append((Object)new MyTemporalAccessor("1"), (Object)new MyTemporalAccessor("1")).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().setTestRecursive(true).append((Object)new MyCharSequence("1"), (Object)new MyCharSequence("1")).isEquals());
        Assertions.assertTrue((boolean)new EqualsBuilder().setTestRecursive(true).append((Object)o1, (Object)o1).isEquals(), o1::toString);
        Assertions.assertTrue((boolean)new EqualsBuilder().setTestRecursive(true).append((Object)o1, (Object)o1Bis).isEquals(), o1::toString);
        Assertions.assertTrue((boolean)new EqualsBuilder().setTestRecursive(true).append((Object)o2, (Object)o2).isEquals(), o2::toString);
        Assertions.assertTrue((boolean)new EqualsBuilder().setTestRecursive(true).append((Object)o2, (Object)o2Bis).isEquals(), o2::toString);
        Assertions.assertFalse((boolean)new EqualsBuilder().setTestRecursive(true).append((Object)o1, (Object)o2).isEquals());
        Assertions.assertFalse((boolean)new EqualsBuilder().setTestRecursive(true).append((Object)o2, (Object)o1).isEquals());
    }

    @Test
    void testRetention() throws Exception {
        for (int i = 0; i < Integer.getInteger("testRetention", 10000); ++i) {
            Class<?> clazz = TestClassBuilder.defineSimpleClass(this.getClass().getPackage().getName(), i);
            Assertions.assertTrue((boolean)new EqualsBuilder().setTestRecursive(true).append(clazz.newInstance(), clazz.newInstance()).isEquals());
        }
    }

    static class MyClass
    implements Cloneable {
        private final MyCharSequence charSequence;
        private final MyTemporal temporal;
        private final MyTemporalAccessor temporalAccessor;
        private final MyTemporalAmount temporalAmount;
        private final Object[] objects;
        private final List<Supplier<?>> list = new ArrayList();

        MyClass(MyCharSequence charSequence, MyTemporal temporal, MyTemporalAccessor temporalAccessor, MyTemporalAmount temporalAmount) {
            this.charSequence = charSequence;
            this.temporal = temporal;
            this.temporalAccessor = temporalAccessor;
            this.temporalAmount = temporalAmount;
            int value = Integer.parseInt(charSequence.toString());
            LocalDate localDate = LocalDate.ofEpochDay(value);
            LocalTime localTime = LocalTime.of(value, value);
            LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
            OffsetDateTime offsetDateTime = OffsetDateTime.of(localDateTime, ZoneOffset.UTC);
            ZoneOffset zoneOffset = ZoneOffset.ofHours(value);
            this.objects = new Object[]{value, localDate, HijrahDate.from(localDate), JapaneseDate.from(localDate), MinguoDate.from(localDate), ThaiBuddhistDate.from(localDate), localDate, localTime, localDateTime, offsetDateTime, OffsetTime.of(localTime, zoneOffset), Year.of(value), YearMonth.of(value, value), ZonedDateTime.of(localDateTime, zoneOffset), zoneOffset, ZoneId.of(zoneOffset.getId())};
            IntStreams.range((int)100).forEach(i -> this.list.add(() -> charSequence));
        }

        public String toString() {
            return String.format("%s[%s, %s, %s, %s, %s]", this.getClass().getSimpleName(), this.charSequence, this.temporal, this.temporalAccessor, this.temporalAmount, Arrays.toString(this.objects));
        }
    }

    static class MyCharSequence
    implements CharSequence {
        private final char[] chars;

        MyCharSequence(char[] chars) {
            this.chars = Arrays.copyOf(chars, chars.length);
        }

        MyCharSequence(char[] chars, int start, int end) {
            this.chars = Arrays.copyOfRange(chars, start, end);
        }

        MyCharSequence(String string) {
            this.chars = string.toCharArray();
        }

        @Override
        public char charAt(int index) {
            return this.chars[index];
        }

        @Override
        public int length() {
            return this.chars.length;
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new MyCharSequence(this.chars, start, end);
        }

        @Override
        public String toString() {
            return new String(this.chars);
        }
    }

    static class MyTemporal
    implements Temporal {
        private final String string;
        private final int value;
        private final Duration duration;
        private final Instant instant;
        private final Period period;

        MyTemporal(String string) {
            this.string = string;
            this.value = Integer.parseInt(string);
            this.instant = Instant.ofEpochMilli(this.value);
            this.duration = Duration.between(this.instant, this.instant.plusMillis(this.value));
            this.period = Period.ofDays(this.value);
        }

        @Override
        public long getLong(TemporalField field) {
            return this.instant.get(field);
        }

        @Override
        public boolean isSupported(TemporalField field) {
            return this.instant.isSupported(field);
        }

        @Override
        public boolean isSupported(TemporalUnit unit) {
            return this.instant.isSupported(unit);
        }

        @Override
        public Temporal plus(long amountToAdd, TemporalUnit unit) {
            return this.instant.plus(amountToAdd, unit);
        }

        public String toString() {
            return String.format("%s[%s, %s, %s, %s]", this.getClass().getSimpleName(), this.string, this.instant, this.duration, this.period);
        }

        @Override
        public long until(Temporal endExclusive, TemporalUnit unit) {
            return this.instant.until(endExclusive, unit);
        }

        @Override
        public Temporal with(TemporalField field, long newValue) {
            return this.instant.with(field, newValue);
        }
    }

    static class MyTemporalAccessor
    implements TemporalAccessor {
        private final String string;
        private final int value;
        private final Instant instant;
        private final Duration duration;
        private final Period period;

        MyTemporalAccessor(String string) {
            this.string = string;
            this.value = Integer.parseInt(string);
            this.instant = Instant.ofEpochMilli(this.value);
            this.duration = Duration.between(this.instant, this.instant.plusMillis(this.value));
            this.period = Period.ofDays(this.value);
        }

        @Override
        public long getLong(TemporalField field) {
            return this.instant.get(field);
        }

        @Override
        public boolean isSupported(TemporalField field) {
            return this.instant.isSupported(field);
        }

        public String toString() {
            return String.format("%s[%s, %s, %s, %s]", this.getClass().getSimpleName(), this.string, this.instant, this.duration, this.period);
        }
    }

    static class MyTemporalAmount
    implements TemporalAmount {
        private final String string;
        private final int value;
        private final Instant instant;
        private final Duration duration;
        private final Period period;

        MyTemporalAmount(String string) {
            this.string = string;
            this.value = Integer.parseInt(string);
            this.instant = Instant.ofEpochMilli(this.value);
            this.duration = Duration.between(this.instant, this.instant.plusMillis(this.value));
            this.period = Period.ofDays(this.value);
        }

        @Override
        public Temporal addTo(Temporal temporal) {
            return this.duration.addTo(temporal);
        }

        @Override
        public long get(TemporalUnit unit) {
            return this.duration.get(unit);
        }

        @Override
        public List<TemporalUnit> getUnits() {
            return this.duration.getUnits();
        }

        @Override
        public Temporal subtractFrom(Temporal temporal) {
            return this.duration.subtractFrom(temporal);
        }

        public String toString() {
            return String.format("%s[%s - %s - %s - %s]", this.getClass().getSimpleName(), this.string, this.instant, this.duration, this.period);
        }
    }
}

