/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.Arrays;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.oper.OperandArray;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.functions.PushableFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.str.UniStringConsumer;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class Concat31
extends SystemFunction
implements PushableFunction {
    @Override
    protected Sequence resultIfEmpty(int arg) {
        return null;
    }

    @Override
    public FunctionItemType getFunctionItemType() {
        Object[] argTypes = new SequenceType[this.getArity()];
        Arrays.fill(argTypes, SequenceType.OPTIONAL_ATOMIC);
        return new SpecificFunctionType((SequenceType[])argTypes, SequenceType.SINGLE_STRING);
    }

    @Override
    public Expression makeOptimizedFunctionCall(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo, Expression ... arguments) throws XPathException {
        if (OperandArray.every(arguments, arg -> arg.getCardinality() == 16384 && arg.getItemType() == BuiltInAtomicType.BOOLEAN)) {
            visitor.getStaticContext().issueWarning("Did you intend to apply string concatenation to boolean operands? Perhaps you intended 'or' rather than '||'. To suppress this warning, use string() on the arguments.", "SXWN9035", arguments[0].getLocation());
        }
        return new SystemFunctionCall.Optimized(this, arguments){

            @Override
            public UnicodeString evaluateAsString(XPathContext context) throws XPathException {
                UnicodeBuilder buffer = new UnicodeBuilder();
                for (Operand o : this.operands()) {
                    Item item = o.getChildExpression().evaluateItem(context);
                    if (item == null) continue;
                    buffer.accept(item.getUnicodeStringValue());
                }
                return buffer.toUnicodeString();
            }

            @Override
            public Item evaluateItem(XPathContext context) throws XPathException {
                return new StringValue(this.evaluateAsString(context));
            }
        };
    }

    @Override
    public StringValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        UnicodeBuilder builder = new UnicodeBuilder();
        for (Sequence arg : arguments) {
            Item head = arg.head();
            if (head == null) continue;
            builder.accept(head.getUnicodeStringValue());
        }
        return new StringValue(builder.toUnicodeString());
    }

    @Override
    public void process(Outputter destination, XPathContext context, Sequence[] arguments) throws XPathException {
        UniStringConsumer output = destination.getStringReceiver(false, Loc.NONE);
        output.open();
        for (Sequence arg : arguments) {
            Item head = arg.head();
            if (head == null) continue;
            output.accept(head.getUnicodeStringValue());
        }
        output.close();
    }

    @Override
    public SequenceType getRequiredType(int arg) {
        return this.getDetails().paramTypes[0];
    }
}

