/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.handler;

import java.util.EventListener;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.runtime.ListenerInfo;
import org.osgi.framework.BundleContext;

public class ListenerHandler
implements Comparable<ListenerHandler> {
    private final long contextServiceId;
    private final ListenerInfo listenerInfo;
    private final ExtServletContext context;
    private final BundleContext bundleContext;
    private volatile EventListener listener;
    protected volatile int useCount;

    public ListenerHandler(long contextServiceId, ExtServletContext context, ListenerInfo listenerInfo, BundleContext bundleContext) {
        this.contextServiceId = contextServiceId;
        this.context = context;
        this.listenerInfo = listenerInfo;
        this.bundleContext = bundleContext;
    }

    @Override
    public int compareTo(ListenerHandler other) {
        return this.listenerInfo.compareTo(other.listenerInfo);
    }

    public ExtServletContext getContext() {
        return this.context;
    }

    public long getContextServiceId() {
        return this.contextServiceId;
    }

    public EventListener getListener() {
        return this.listener;
    }

    public ListenerInfo getListenerInfo() {
        return this.listenerInfo;
    }

    public boolean destroy() {
        EventListener l = this.listener;
        if (l != null) {
            --this.useCount;
            if (this.useCount == 0) {
                this.listener = null;
                this.getListenerInfo().ungetService(this.bundleContext, l);
                return true;
            }
        }
        return false;
    }

    public boolean dispose() {
        this.useCount = 1;
        return this.destroy();
    }

    public int init() {
        int reason;
        if (this.useCount > 0) {
            ++this.useCount;
            return -1;
        }
        this.listener = (EventListener)this.getListenerInfo().getService(this.bundleContext);
        if (this.listener == null) {
            reason = 5;
        } else {
            ++this.useCount;
            reason = -1;
        }
        return reason;
    }

    public int hashCode() {
        return 31 + this.listenerInfo.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ListenerHandler other = (ListenerHandler)obj;
        return this.listenerInfo.equals(other.listenerInfo);
    }
}

