/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.ajax;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.util.ajax.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONPojoConvertor
implements JSON.Convertor {
    private static final Logger LOG = LoggerFactory.getLogger(JSONPojoConvertor.class);
    private static final Map<Class<?>, NumberType> __numberTypes = new HashMap();
    private static final NumberType SHORT = Number::shortValue;
    private static final NumberType INTEGER = Number::intValue;
    private static final NumberType FLOAT = Number::floatValue;
    private static final NumberType LONG = Number::longValue;
    private static final NumberType DOUBLE = Number::doubleValue;
    protected boolean _fromJSON;
    protected Class<?> _pojoClass;
    protected Map<String, Method> _getters = new HashMap<String, Method>();
    protected Map<String, Setter> _setters = new HashMap<String, Setter>();
    protected Set<String> _excluded;

    public static NumberType getNumberType(Class<?> clazz) {
        return __numberTypes.get(clazz);
    }

    public JSONPojoConvertor(Class<?> pojoClass) {
        this(pojoClass, null, true);
    }

    public JSONPojoConvertor(Class<?> pojoClass, boolean fromJSON) {
        this(pojoClass, null, fromJSON);
    }

    public JSONPojoConvertor(Class<?> pojoClass, String[] excluded) {
        this(pojoClass, new HashSet<String>(Arrays.asList(excluded)));
    }

    public JSONPojoConvertor(Class<?> pojoClass, Set<String> excluded) {
        this(pojoClass, excluded, true);
    }

    public JSONPojoConvertor(Class<?> pojoClass, Set<String> excluded, boolean fromJSON) {
        this._pojoClass = pojoClass;
        this._excluded = excluded;
        this._fromJSON = fromJSON;
        this.init();
    }

    protected void init() {
        Method[] methods;
        block4: for (Method m : methods = this._pojoClass.getMethods()) {
            if (Modifier.isStatic(m.getModifiers()) || m.getDeclaringClass() == Object.class) continue;
            Object name = m.getName();
            switch (m.getParameterCount()) {
                case 0: {
                    if (m.getReturnType() == null) continue block4;
                    if (((String)name).startsWith("is") && ((String)name).length() > 2) {
                        name = ((String)name).substring(2, 3).toLowerCase(Locale.ENGLISH) + ((String)name).substring(3);
                    } else {
                        if (!((String)name).startsWith("get") || ((String)name).length() <= 3) continue block4;
                        name = ((String)name).substring(3, 4).toLowerCase(Locale.ENGLISH) + ((String)name).substring(4);
                    }
                    if (!this.includeField((String)name, m)) continue block4;
                    this.addGetter((String)name, m);
                    continue block4;
                }
                case 1: {
                    if (!((String)name).startsWith("set") || ((String)name).length() <= 3 || !this.includeField((String)(name = ((String)name).substring(3, 4).toLowerCase(Locale.ENGLISH) + ((String)name).substring(4)), m)) continue block4;
                    this.addSetter((String)name, m);
                    continue block4;
                }
            }
        }
    }

    protected void addGetter(String name, Method method) {
        this._getters.put(name, method);
    }

    protected void addSetter(String name, Method method) {
        this._setters.put(name, new Setter(name, method));
    }

    protected Setter getSetter(String name) {
        return this._setters.get(name);
    }

    protected boolean includeField(String name, Method m) {
        return this._excluded == null || !this._excluded.contains(name);
    }

    @Override
    public Object fromJSON(Map<String, Object> object) {
        try {
            Object obj = this._pojoClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.setProps(obj, object);
            return obj;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setProps(Object obj, Map<String, Object> props) {
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            Setter setter = this.getSetter(entry.getKey());
            if (setter == null) continue;
            try {
                setter.invoke(obj, entry.getValue());
            }
            catch (Exception e) {
                LOG.warn("{}#{} not set from value {}={}: {}", new Object[]{this._pojoClass.getName(), setter.getPropertyName(), setter.getType().getName(), entry.getValue(), e.toString()});
            }
        }
    }

    @Override
    public void toJSON(Object obj, JSON.Output out) {
        if (this._fromJSON) {
            out.addClass(this._pojoClass);
        }
        for (Map.Entry<String, Method> entry : this._getters.entrySet()) {
            try {
                out.add(entry.getKey(), entry.getValue().invoke(obj, new Object[0]));
            }
            catch (Exception e) {
                LOG.warn("{}#{} excluded: {}", new Object[]{this._pojoClass.getName(), entry.getKey(), e.toString()});
            }
        }
    }

    static {
        __numberTypes.put(Short.class, SHORT);
        __numberTypes.put(Short.TYPE, SHORT);
        __numberTypes.put(Integer.class, INTEGER);
        __numberTypes.put(Integer.TYPE, INTEGER);
        __numberTypes.put(Long.class, LONG);
        __numberTypes.put(Long.TYPE, LONG);
        __numberTypes.put(Float.class, FLOAT);
        __numberTypes.put(Float.TYPE, FLOAT);
        __numberTypes.put(Double.class, DOUBLE);
        __numberTypes.put(Double.TYPE, DOUBLE);
    }

    public static interface NumberType {
        public Object getActualValue(Number var1);
    }

    public static class Setter {
        protected String _propertyName;
        protected Method _setter;
        protected NumberType _numberType;
        protected Class<?> _type;
        protected Class<?> _componentType;

        public Setter(String propertyName, Method method) {
            this._propertyName = propertyName;
            this._setter = method;
            this._type = method.getParameterTypes()[0];
            this._numberType = JSONPojoConvertor.getNumberType(this._type);
            if (this._numberType == null && this._type.isArray()) {
                this._componentType = this._type.getComponentType();
                this._numberType = JSONPojoConvertor.getNumberType(this._componentType);
            }
        }

        public String getPropertyName() {
            return this._propertyName;
        }

        public Method getMethod() {
            return this._setter;
        }

        public NumberType getNumberType() {
            return this._numberType;
        }

        public Class<?> getType() {
            return this._type;
        }

        public Class<?> getComponentType() {
            return this._componentType;
        }

        public boolean isPropertyNumber() {
            return this.getNumberType() != null;
        }

        public void invoke(Object obj, Object value) throws Exception {
            if (value == null) {
                this._setter.invoke(obj, value);
            } else {
                this.invokeObject(obj, value);
            }
        }

        protected void invokeObject(Object obj, Object value) throws Exception {
            if (this._type.isEnum()) {
                if (value instanceof Enum) {
                    this._setter.invoke(obj, value);
                } else {
                    Class<?> enumType = this._type;
                    Object enumValue = Enum.valueOf(enumType, value.toString());
                    this._setter.invoke(obj, enumValue);
                }
            } else if (this.isPropertyNumber() && value instanceof Number) {
                this._setter.invoke(obj, this._numberType.getActualValue((Number)value));
            } else if (Character.TYPE.equals(this._type) || Character.class.equals(this._type)) {
                this._setter.invoke(obj, Character.valueOf(String.valueOf(value).charAt(0)));
            } else if (this._componentType != null && value.getClass().isArray()) {
                if (this._numberType == null) {
                    int len = Array.getLength(value);
                    Object array = Array.newInstance(this.getComponentType(), len);
                    try {
                        System.arraycopy(value, 0, array, 0, len);
                        this._setter.invoke(obj, array);
                    }
                    catch (Exception e) {
                        LOG.trace("IGNORED", (Throwable)e);
                        this._setter.invoke(obj, value);
                    }
                } else {
                    Object[] old = (Object[])value;
                    Object array = Array.newInstance(this.getComponentType(), old.length);
                    try {
                        for (int i = 0; i < old.length; ++i) {
                            Array.set(array, i, this._numberType.getActualValue((Number)old[i]));
                        }
                        this._setter.invoke(obj, array);
                    }
                    catch (Exception e) {
                        LOG.trace("IGNORED", (Throwable)e);
                        this._setter.invoke(obj, value);
                    }
                }
            } else {
                this._setter.invoke(obj, value);
            }
        }
    }
}

