/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.system;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Map;
import org.apache.felix.utils.json.JSONWriter;
import org.apache.felix.webconsole.internal.Util;
import org.apache.felix.webconsole.internal.servlet.AbstractOsgiManagerPlugin;
import org.apache.felix.webconsole.servlet.RequestVariableResolver;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.startlevel.FrameworkStartLevel;

public class VMStatPlugin
extends AbstractOsgiManagerPlugin {
    private static final long serialVersionUID = 2293375003997163600L;
    private static final String LABEL = "vmstat";
    private static final String TITLE = "%vmstat.pluginTitle";
    private static final String ATTR_TERMINATED = "terminated";
    private static final String PARAM_SHUTDOWN_TIMER = "shutdown_timer";
    private static final String PARAM_SHUTDOWN_TYPE = "shutdown_type";
    private static final String PARAM_SHUTDOWN_TYPE_RESTART = "Restart";
    private static final long startDate = System.currentTimeMillis();
    private final String TPL_VM_MAIN = this.readTemplateFile("/templates/vmstat.html");
    private final String TPL_VM_STOP = this.readTemplateFile("/templates/vmstat_stop.html");
    private final String TPL_VM_RESTART = this.readTemplateFile("/templates/vmstat_restart.html");

    @Override
    protected String getCategory() {
        return "Web Console";
    }

    @Override
    protected String getLabel() {
        return LABEL;
    }

    @Override
    protected String getTitle() {
        return TITLE;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String action = request.getParameter("action");
        if ("setStartLevel".equals(action)) {
            FrameworkStartLevel fsl = (FrameworkStartLevel)this.getBundleContext().getBundle("System Bundle").adapt(FrameworkStartLevel.class);
            if (fsl != null) {
                int systemSL;
                int bundleSL = this.getParameterInt(request, "bundleStartLevel", -1);
                if (bundleSL > 0 && bundleSL != fsl.getInitialBundleStartLevel()) {
                    fsl.setInitialBundleStartLevel(bundleSL);
                }
                if ((systemSL = this.getParameterInt(request, "systemStartLevel", -1)) > 0 && systemSL != fsl.getStartLevel()) {
                    fsl.setStartLevel(systemSL, new FrameworkListener[0]);
                }
            }
        } else if ("gc".equals(action)) {
            System.gc();
            System.gc();
        } else if (request.getParameter(PARAM_SHUTDOWN_TIMER) == null) {
            final boolean restart = PARAM_SHUTDOWN_TYPE_RESTART.equals(request.getParameter(PARAM_SHUTDOWN_TYPE));
            final Bundle systemBundle = this.getBundleContext().getBundle(0L);
            Thread t = new Thread("Stopper"){

                @Override
                public void run() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Util.LOGGER.info("Shutting down server now!");
                    try {
                        if (restart) {
                            systemBundle.update();
                        } else {
                            systemBundle.stop();
                        }
                    }
                    catch (BundleException be) {
                        Util.LOGGER.error("Problem stopping or restarting the Framework", (Throwable)be);
                    }
                }
            };
            t.start();
            request.setAttribute(ATTR_TERMINATED, (Object)ATTR_TERMINATED);
            request.setAttribute(PARAM_SHUTDOWN_TYPE, (Object)restart);
        }
        this.doGet(request, response);
    }

    @Override
    public void renderContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        FrameworkStartLevel fsl = (FrameworkStartLevel)this.getBundleContext().getBundle("System Bundle").adapt(FrameworkStartLevel.class);
        Map configuration = (Map)request.getAttribute("felix.webconsole.configuration");
        if (request.getAttribute(ATTR_TERMINATED) != null) {
            String body;
            Object restart = request.getAttribute(PARAM_SHUTDOWN_TYPE);
            if (restart instanceof Boolean && ((Boolean)restart).booleanValue()) {
                StringWriter json = new StringWriter();
                int reloadTimeout = (Integer)configuration.get("reload.timeout");
                JSONWriter jw = new JSONWriter(json);
                jw.object();
                jw.key("reloadTimeout").value(reloadTimeout);
                jw.endObject();
                jw.flush();
                RequestVariableResolver vars = this.getVariableResolver(request);
                vars.put("data", json.toString());
                body = this.TPL_VM_RESTART;
            } else {
                body = this.TPL_VM_STOP;
            }
            response.getWriter().print(body);
            return;
        }
        String body = this.TPL_VM_MAIN;
        long freeMem = Runtime.getRuntime().freeMemory() / 1024L;
        long totalMem = Runtime.getRuntime().totalMemory() / 1024L;
        long usedMem = totalMem - freeMem;
        boolean shutdownTimer = request.getParameter(PARAM_SHUTDOWN_TIMER) != null;
        String shutdownType = request.getParameter(PARAM_SHUTDOWN_TYPE);
        if (shutdownType == null) {
            shutdownType = "";
        }
        DateFormat format = DateFormat.getDateTimeInstance(1, 1, request.getLocale());
        String startTime = format.format(new Date(startDate));
        String upTime = VMStatPlugin.formatPeriod(System.currentTimeMillis() - startDate);
        StringWriter json = new StringWriter();
        JSONWriter jw = new JSONWriter(json);
        jw.object();
        jw.key("systemStartLevel").value(fsl.getStartLevel());
        jw.key("bundleStartLevel").value(fsl.getInitialBundleStartLevel());
        jw.key("lastStarted").value(startTime);
        jw.key("upTime").value(upTime);
        jw.key("runtime").value(VMStatPlugin.sysProp("java.runtime.name") + "(build " + VMStatPlugin.sysProp("java.runtime.version") + ")");
        jw.key("jvm").value(VMStatPlugin.sysProp("java.vm.name") + "(build " + VMStatPlugin.sysProp("java.vm.version") + ", " + VMStatPlugin.sysProp("java.vm.info") + ")");
        jw.key("shutdownTimer").value(shutdownTimer);
        jw.key("mem_total").value(totalMem);
        jw.key("mem_free").value(freeMem);
        jw.key("mem_used").value(usedMem);
        jw.key("shutdownType").value(shutdownType);
        int shutdownTimeout = (Integer)configuration.get("shutdown.timeout");
        jw.key("shutdownTimeout").value(shutdownTimeout);
        int processors = VMStatPlugin.getAvailableProcessors();
        if (processors > 0) {
            jw.key("processors").value(processors);
        }
        jw.endObject();
        jw.flush();
        RequestVariableResolver vars = this.getVariableResolver(request);
        vars.put("startData", json.toString());
        response.getWriter().print(body);
    }

    private static final String sysProp(String name) {
        String ret = System.getProperty(name);
        if (null == ret || ret.length() == 0) {
            ret = "n/a";
        }
        return ret;
    }

    private static final String formatPeriod(long period) {
        long msecs = period % 1000L;
        long secs = period / 1000L % 60L;
        long mins = period / 1000L / 60L % 60L;
        long hours = period / 1000L / 60L / 60L % 24L;
        long days = period / 1000L / 60L / 60L / 24L;
        return MessageFormat.format("{0,number} '${vmstat.upTime.format.days}' {1,number,00}:{2,number,00}:{3,number,00}.{4,number,000}", days, hours, mins, secs, msecs);
    }

    private static final int getAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }
}

