/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.runtime.context;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.flink.agents.api.Event;
import org.apache.flink.agents.api.configuration.ReadableConfiguration;
import org.apache.flink.agents.api.context.MemoryObject;
import org.apache.flink.agents.api.context.MemoryUpdate;
import org.apache.flink.agents.api.context.RunnerContext;
import org.apache.flink.agents.api.resource.Resource;
import org.apache.flink.agents.api.resource.ResourceType;
import org.apache.flink.agents.plan.AgentPlan;
import org.apache.flink.agents.plan.utils.JsonUtils;
import org.apache.flink.agents.runtime.memory.CachedMemoryStore;
import org.apache.flink.agents.runtime.memory.MemoryObjectImpl;
import org.apache.flink.agents.runtime.metrics.FlinkAgentsMetricGroupImpl;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.util.Preconditions;

public class RunnerContextImpl
implements RunnerContext {
    protected final List<Event> pendingEvents = new ArrayList<Event>();
    protected final CachedMemoryStore store;
    protected final FlinkAgentsMetricGroupImpl agentMetricGroup;
    protected final Runnable mailboxThreadChecker;
    protected final AgentPlan agentPlan;
    protected final List<MemoryUpdate> memoryUpdates;
    protected String actionName;

    public RunnerContextImpl(CachedMemoryStore store, FlinkAgentsMetricGroupImpl agentMetricGroup, Runnable mailboxThreadChecker, AgentPlan agentPlan) {
        this.store = store;
        this.agentMetricGroup = agentMetricGroup;
        this.mailboxThreadChecker = mailboxThreadChecker;
        this.agentPlan = agentPlan;
        this.memoryUpdates = new LinkedList<MemoryUpdate>();
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    @Override
    public FlinkAgentsMetricGroupImpl getAgentMetricGroup() {
        return this.agentMetricGroup;
    }

    @Override
    public FlinkAgentsMetricGroupImpl getActionMetricGroup() {
        return this.agentMetricGroup.getSubGroup(this.actionName);
    }

    @Override
    public void sendEvent(Event event) {
        this.mailboxThreadChecker.run();
        try {
            JsonUtils.checkSerializable(event);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Event is not JSON serializable. All events sent to context must be JSON serializable.", e);
        }
        this.pendingEvents.add(event);
    }

    public List<Event> drainEvents(Long timestamp) {
        this.mailboxThreadChecker.run();
        ArrayList<Event> list = new ArrayList<Event>(this.pendingEvents);
        if (timestamp != null) {
            list.forEach(event -> event.setSourceTimestamp(timestamp));
        }
        this.pendingEvents.clear();
        return list;
    }

    public void checkNoPendingEvents() {
        Preconditions.checkState((boolean)this.pendingEvents.isEmpty(), (Object)"There are pending events remaining in the context.");
    }

    public List<MemoryUpdate> getAllMemoryUpdates() {
        this.mailboxThreadChecker.run();
        return List.copyOf(this.memoryUpdates);
    }

    @Override
    public MemoryObject getShortTermMemory() throws Exception {
        this.mailboxThreadChecker.run();
        return new MemoryObjectImpl(this.store, "", this.mailboxThreadChecker, this.memoryUpdates);
    }

    @Override
    public Resource getResource(String name, ResourceType type) throws Exception {
        if (this.agentPlan == null) {
            throw new IllegalStateException("AgentPlan is not available in this context");
        }
        return this.agentPlan.getResource(name, type);
    }

    @Override
    public ReadableConfiguration getConfig() {
        return this.agentPlan.getConfig();
    }

    @Override
    public Map<String, Object> getActionConfig() {
        return this.agentPlan.getActionConfig(this.actionName);
    }

    @Override
    public Object getActionConfigValue(String key) {
        return this.agentPlan.getActionConfigValue(this.actionName, key);
    }

    public String getActionName() {
        return this.actionName;
    }

    public void persistMemory() throws Exception {
        this.store.persistCache();
    }
}

