/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.http.ReadableByteChannelMock;
import org.apache.hc.core5.http.impl.BasicHttpTransportMetrics;
import org.apache.hc.core5.http.impl.nio.CodecTestUtils;
import org.apache.hc.core5.http.impl.nio.IdentityDecoder;
import org.apache.hc.core5.http.impl.nio.SessionInputBufferImpl;
import org.apache.hc.core5.http.nio.SessionInputBuffer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestIdentityDecoder {
    private File tmpfile;

    TestIdentityDecoder() {
    }

    protected File createTempFile() throws IOException {
        this.tmpfile = File.createTempFile("testFile", ".txt");
        return this.tmpfile;
    }

    @AfterEach
    void deleteTempFile() {
        if (this.tmpfile != null && this.tmpfile.exists()) {
            this.tmpfile.delete();
        }
    }

    @Test
    void testBasicDecoding() throws Exception {
        ReadableByteChannelMock channel = new ReadableByteChannelMock(new String[]{"stuff;", "more stuff"}, StandardCharsets.US_ASCII);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(1024, 256, 0, StandardCharsets.US_ASCII);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        IdentityDecoder decoder = new IdentityDecoder((ReadableByteChannel)channel, (SessionInputBuffer)inbuf, metrics);
        ByteBuffer dst = ByteBuffer.allocate(1024);
        int bytesRead = decoder.read(dst);
        Assertions.assertEquals((int)6, (int)bytesRead);
        Assertions.assertEquals((Object)"stuff;", (Object)CodecTestUtils.convert(dst));
        Assertions.assertFalse((boolean)decoder.isCompleted());
        Assertions.assertEquals((long)6L, (long)metrics.getBytesTransferred());
        dst.clear();
        bytesRead = decoder.read(dst);
        Assertions.assertEquals((int)10, (int)bytesRead);
        Assertions.assertEquals((Object)"more stuff", (Object)CodecTestUtils.convert(dst));
        Assertions.assertFalse((boolean)decoder.isCompleted());
        Assertions.assertEquals((long)16L, (long)metrics.getBytesTransferred());
        dst.clear();
        bytesRead = decoder.read(dst);
        Assertions.assertEquals((int)-1, (int)bytesRead);
        Assertions.assertTrue((boolean)decoder.isCompleted());
        Assertions.assertEquals((long)16L, (long)metrics.getBytesTransferred());
        dst.clear();
        bytesRead = decoder.read(dst);
        Assertions.assertEquals((int)-1, (int)bytesRead);
        Assertions.assertTrue((boolean)decoder.isCompleted());
        Assertions.assertEquals((long)16L, (long)metrics.getBytesTransferred());
        Assertions.assertEquals((Object)"[identity; completed: true]", (Object)decoder.toString());
    }

    @Test
    void testDecodingFromSessionBuffer() throws Exception {
        ReadableByteChannelMock channel = new ReadableByteChannelMock(new String[]{"stuff;", "more stuff"}, StandardCharsets.US_ASCII);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(1024, 256, 0, StandardCharsets.US_ASCII);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        inbuf.fill((ReadableByteChannel)channel);
        Assertions.assertEquals((int)6, (int)inbuf.length());
        IdentityDecoder decoder = new IdentityDecoder((ReadableByteChannel)channel, (SessionInputBuffer)inbuf, metrics);
        ByteBuffer dst = ByteBuffer.allocate(1024);
        int bytesRead = decoder.read(dst);
        Assertions.assertEquals((int)6, (int)bytesRead);
        Assertions.assertEquals((Object)"stuff;", (Object)CodecTestUtils.convert(dst));
        Assertions.assertFalse((boolean)decoder.isCompleted());
        Assertions.assertEquals((long)0L, (long)metrics.getBytesTransferred());
        dst.clear();
        bytesRead = decoder.read(dst);
        Assertions.assertEquals((int)10, (int)bytesRead);
        Assertions.assertEquals((Object)"more stuff", (Object)CodecTestUtils.convert(dst));
        Assertions.assertFalse((boolean)decoder.isCompleted());
        Assertions.assertEquals((long)10L, (long)metrics.getBytesTransferred());
        dst.clear();
        bytesRead = decoder.read(dst);
        Assertions.assertEquals((int)-1, (int)bytesRead);
        Assertions.assertTrue((boolean)decoder.isCompleted());
        Assertions.assertEquals((long)10L, (long)metrics.getBytesTransferred());
        dst.clear();
        bytesRead = decoder.read(dst);
        Assertions.assertEquals((int)-1, (int)bytesRead);
        Assertions.assertTrue((boolean)decoder.isCompleted());
        Assertions.assertEquals((long)10L, (long)metrics.getBytesTransferred());
    }

    @Test
    void testBasicDecodingFile() throws Exception {
        ReadableByteChannelMock channel = new ReadableByteChannelMock(new String[]{"stuff; ", "more stuff; ", "a lot more stuff!"}, StandardCharsets.US_ASCII);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(1024, 256, 0, StandardCharsets.US_ASCII);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        IdentityDecoder decoder = new IdentityDecoder((ReadableByteChannel)channel, (SessionInputBuffer)inbuf, metrics);
        this.createTempFile();
        try (RandomAccessFile testfile = new RandomAccessFile(this.tmpfile, "rw");){
            FileChannel fchannel = testfile.getChannel();
            long pos = 0L;
            while (!decoder.isCompleted()) {
                long bytesRead = decoder.transfer(fchannel, pos, 10L);
                if (bytesRead <= 0L) continue;
                pos += bytesRead;
            }
            Assertions.assertEquals((long)testfile.length(), (long)metrics.getBytesTransferred());
        }
        Assertions.assertEquals((Object)"stuff; more stuff; a lot more stuff!", (Object)CodecTestUtils.readFromFile(this.tmpfile));
    }

    @Test
    void testDecodingFileWithBufferedSessionData() throws Exception {
        ReadableByteChannelMock channel = new ReadableByteChannelMock(new String[]{"stuff; ", "more stuff; ", "a lot more stuff!"}, StandardCharsets.US_ASCII);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(1024, 256, 0, StandardCharsets.US_ASCII);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        IdentityDecoder decoder = new IdentityDecoder((ReadableByteChannel)channel, (SessionInputBuffer)inbuf, metrics);
        int i = inbuf.fill((ReadableByteChannel)channel);
        Assertions.assertEquals((int)7, (int)i);
        this.createTempFile();
        try (RandomAccessFile testfile = new RandomAccessFile(this.tmpfile, "rw");){
            FileChannel fchannel = testfile.getChannel();
            long pos = 0L;
            while (!decoder.isCompleted()) {
                long bytesRead = decoder.transfer(fchannel, pos, 10L);
                if (bytesRead <= 0L) continue;
                pos += bytesRead;
            }
            Assertions.assertEquals((long)(testfile.length() - 7L), (long)metrics.getBytesTransferred());
        }
        Assertions.assertEquals((Object)"stuff; more stuff; a lot more stuff!", (Object)CodecTestUtils.readFromFile(this.tmpfile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testDecodingFileWithOffsetAndBufferedSessionData() throws Exception {
        ReadableByteChannelMock channel = new ReadableByteChannelMock(new String[]{"stuff; ", "more stuff; ", "a lot more stuff!"}, StandardCharsets.US_ASCII);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(1024, 256, 0, StandardCharsets.US_ASCII);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        IdentityDecoder decoder = new IdentityDecoder((ReadableByteChannel)channel, (SessionInputBuffer)inbuf, metrics);
        int i = inbuf.fill((ReadableByteChannel)channel);
        Assertions.assertEquals((int)7, (int)i);
        byte[] beginning = "beginning; ".getBytes(StandardCharsets.US_ASCII);
        this.createTempFile();
        try (RandomAccessFile testfile = new RandomAccessFile(this.tmpfile, "rw");){
            testfile.write(beginning);
        }
        testfile = new RandomAccessFile(this.tmpfile, "rw");
        try {
            FileChannel fchannel = testfile.getChannel();
            long pos = beginning.length;
            while (!decoder.isCompleted()) {
                long bytesRead;
                if (testfile.length() < pos) {
                    testfile.setLength(pos);
                }
                if ((bytesRead = decoder.transfer(fchannel, pos, 10L)) <= 0L) continue;
                pos += bytesRead;
            }
            Assertions.assertEquals((long)(testfile.length() - 7L - (long)beginning.length), (long)metrics.getBytesTransferred());
        }
        finally {
            testfile.close();
        }
        Assertions.assertEquals((Object)"beginning; stuff; more stuff; a lot more stuff!", (Object)CodecTestUtils.readFromFile(this.tmpfile));
    }

    @Test
    void testDecodingFileWithLimit() throws Exception {
        ReadableByteChannelMock channel = new ReadableByteChannelMock(new String[]{"stuff; more stuff; ", "a lot more stuff!"}, StandardCharsets.US_ASCII);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(1024, 256, 0, StandardCharsets.US_ASCII);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        IdentityDecoder decoder = new IdentityDecoder((ReadableByteChannel)channel, (SessionInputBuffer)inbuf, metrics);
        int i = inbuf.fill((ReadableByteChannel)channel);
        Assertions.assertEquals((int)19, (int)i);
        this.createTempFile();
        try (RandomAccessFile testfile = new RandomAccessFile(this.tmpfile, "rw");){
            FileChannel fchannel = testfile.getChannel();
            long pos = 0L;
            long bytesRead = decoder.transfer(fchannel, pos, 1L);
            Assertions.assertEquals((long)1L, (long)bytesRead);
            Assertions.assertFalse((boolean)decoder.isCompleted());
            Assertions.assertEquals((long)0L, (long)metrics.getBytesTransferred());
            pos += bytesRead;
            bytesRead = decoder.transfer(fchannel, pos, 2L);
            Assertions.assertEquals((long)2L, (long)bytesRead);
            Assertions.assertFalse((boolean)decoder.isCompleted());
            Assertions.assertEquals((long)0L, (long)metrics.getBytesTransferred());
            pos += bytesRead;
            bytesRead = decoder.transfer(fchannel, pos, 17L);
            Assertions.assertEquals((long)16L, (long)bytesRead);
            Assertions.assertFalse((boolean)decoder.isCompleted());
            Assertions.assertEquals((long)0L, (long)metrics.getBytesTransferred());
            pos += bytesRead;
            bytesRead = decoder.transfer(fchannel, pos, 1L);
            Assertions.assertEquals((long)1L, (long)bytesRead);
            Assertions.assertFalse((boolean)decoder.isCompleted());
            Assertions.assertEquals((long)1L, (long)metrics.getBytesTransferred());
            pos += bytesRead;
            bytesRead = decoder.transfer(fchannel, pos, 2L);
            Assertions.assertEquals((long)2L, (long)bytesRead);
            Assertions.assertFalse((boolean)decoder.isCompleted());
            Assertions.assertEquals((long)3L, (long)metrics.getBytesTransferred());
            pos += bytesRead;
            bytesRead = decoder.transfer(fchannel, pos, 15L);
            Assertions.assertEquals((long)14L, (long)bytesRead);
            Assertions.assertFalse((boolean)decoder.isCompleted());
            Assertions.assertEquals((long)17L, (long)metrics.getBytesTransferred());
            pos += bytesRead;
            bytesRead = decoder.transfer(fchannel, pos, 1L);
            Assertions.assertEquals((long)-1L, (long)bytesRead);
            Assertions.assertTrue((boolean)decoder.isCompleted());
            Assertions.assertEquals((long)17L, (long)metrics.getBytesTransferred());
        }
        Assertions.assertEquals((Object)"stuff; more stuff; a lot more stuff!", (Object)CodecTestUtils.readFromFile(this.tmpfile));
    }

    @Test
    void testWriteBeyondFileSize() throws Exception {
        ReadableByteChannelMock channel = new ReadableByteChannelMock(new String[]{"a"}, StandardCharsets.US_ASCII);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(1024, 256, 0, StandardCharsets.US_ASCII);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        IdentityDecoder decoder = new IdentityDecoder((ReadableByteChannel)channel, (SessionInputBuffer)inbuf, metrics);
        this.createTempFile();
        try (RandomAccessFile testfile = new RandomAccessFile(this.tmpfile, "rw");){
            Assertions.assertEquals((long)0L, (long)testfile.length());
            FileChannel fchannel = testfile.getChannel();
            Assertions.assertThrows(IOException.class, () -> decoder.transfer(fchannel, 5L, 10L));
        }
    }

    @Test
    void testInvalidConstructor() {
        ReadableByteChannelMock channel = new ReadableByteChannelMock(new String[]{"stuff;", "more stuff"}, StandardCharsets.US_ASCII);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(1024, 256, 0, StandardCharsets.US_ASCII);
        Assertions.assertThrows(NullPointerException.class, () -> new IdentityDecoder(null, null, null));
        Assertions.assertThrows(NullPointerException.class, () -> new IdentityDecoder(channel, null, null));
        Assertions.assertThrows(NullPointerException.class, () -> TestIdentityDecoder.lambda$testInvalidConstructor$3(channel, (SessionInputBuffer)inbuf));
    }

    @Test
    void testInvalidInput() {
        String s = "stuff";
        ReadableByteChannelMock channel = new ReadableByteChannelMock(new String[]{"stuff"}, StandardCharsets.US_ASCII);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(1024, 256, 0, StandardCharsets.US_ASCII);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        IdentityDecoder decoder = new IdentityDecoder((ReadableByteChannel)channel, (SessionInputBuffer)inbuf, metrics);
        Assertions.assertThrows(NullPointerException.class, () -> decoder.read(null));
    }

    private static /* synthetic */ void lambda$testInvalidConstructor$3(ReadableByteChannel channel, SessionInputBuffer inbuf) throws Throwable {
        new IdentityDecoder(channel, inbuf, null);
    }
}

