/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.List;
import org.apache.iceberg.BaseChangelogContentScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.DeletedDataFileScanTask;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;

class BaseDeletedDataFileScanTask
extends BaseChangelogContentScanTask<DeletedDataFileScanTask, DataFile>
implements DeletedDataFileScanTask {
    private final DeleteFile[] deletes;

    BaseDeletedDataFileScanTask(int changeOrdinal, long commitSnapshotId, DataFile file, DeleteFile[] deletes, String schemaString, String specString, ResidualEvaluator residuals) {
        super(changeOrdinal, commitSnapshotId, file, schemaString, specString, residuals);
        this.deletes = deletes != null ? deletes : new DeleteFile[]{};
    }

    @Override
    protected DeletedDataFileScanTask self() {
        return this;
    }

    @Override
    protected DeletedDataFileScanTask newSplitTask(DeletedDataFileScanTask parentTask, long offset, long length) {
        return new SplitDeletedDataFileScanTask(parentTask, offset, length);
    }

    public List<DeleteFile> existingDeletes() {
        return ImmutableList.copyOf((Object[])this.deletes);
    }

    private static class SplitDeletedDataFileScanTask
    extends BaseChangelogContentScanTask.SplitScanTask<SplitDeletedDataFileScanTask, DeletedDataFileScanTask, DataFile>
    implements DeletedDataFileScanTask {
        SplitDeletedDataFileScanTask(DeletedDataFileScanTask parentTask, long offset, long length) {
            super(parentTask, offset, length);
        }

        @Override
        protected SplitDeletedDataFileScanTask copyWithNewLength(long newLength) {
            return new SplitDeletedDataFileScanTask((DeletedDataFileScanTask)this.parentTask(), this.start(), newLength);
        }

        public List<DeleteFile> existingDeletes() {
            return ((DeletedDataFileScanTask)this.parentTask()).existingDeletes();
        }
    }
}

