/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.encryption;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.iceberg.encryption.Ciphers;
import org.apache.iceberg.io.PositionOutputStream;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class AesGcmOutputStream
extends PositionOutputStream {
    private static final byte[] HEADER_BYTES = ByteBuffer.allocate(Ciphers.GCM_STREAM_HEADER_LENGTH).order(ByteOrder.LITTLE_ENDIAN).put(Ciphers.GCM_STREAM_MAGIC_ARRAY).putInt(0x100000).array();
    private final Ciphers.AesGcmEncryptor gcmEncryptor;
    private final PositionOutputStream targetStream;
    private final byte[] fileAadPrefix;
    private final byte[] singleByte;
    private final byte[] plainBlock;
    private final byte[] cipherBlock;
    private int positionInPlainBlock;
    private int currentBlockIndex;
    private boolean isHeaderWritten;
    private boolean lastBlockWritten;
    private boolean isClosed;
    private long finalPosition;

    AesGcmOutputStream(PositionOutputStream targetStream, byte[] aesKey, byte[] fileAadPrefix) {
        this.targetStream = targetStream;
        this.gcmEncryptor = new Ciphers.AesGcmEncryptor(aesKey);
        this.fileAadPrefix = fileAadPrefix;
        this.singleByte = new byte[1];
        this.plainBlock = new byte[0x100000];
        this.cipherBlock = new byte[0x10001C];
        this.positionInPlainBlock = 0;
        this.currentBlockIndex = 0;
        this.isHeaderWritten = false;
        this.lastBlockWritten = false;
        this.isClosed = false;
        this.finalPosition = 0L;
    }

    public void write(int b) throws IOException {
        this.singleByte[0] = (byte)(b & 0xFF);
        this.write(this.singleByte);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int toWrite;
        if (this.isClosed) {
            throw new IOException("Writing to closed stream");
        }
        if (!this.isHeaderWritten) {
            this.writeHeader();
        }
        if (b.length - off < len) {
            throw new IOException("Insufficient bytes in buffer: " + b.length + " - " + off + " < " + len);
        }
        int offset = off;
        for (int remaining = len; remaining > 0; remaining -= toWrite) {
            int freeBlockBytes = this.plainBlock.length - this.positionInPlainBlock;
            toWrite = Math.min(freeBlockBytes, remaining);
            System.arraycopy(b, offset, this.plainBlock, this.positionInPlainBlock, toWrite);
            this.positionInPlainBlock += toWrite;
            offset += toWrite;
            if (this.positionInPlainBlock != this.plainBlock.length) continue;
            this.encryptAndWriteBlock();
        }
    }

    public long getPos() throws IOException {
        if (this.isClosed) {
            return this.finalPosition;
        }
        return (long)this.currentBlockIndex * 0x100000L + (long)this.positionInPlainBlock;
    }

    public void flush() throws IOException {
        this.targetStream.flush();
    }

    public void close() throws IOException {
        if (!this.isHeaderWritten) {
            this.writeHeader();
        }
        this.finalPosition = this.getPos();
        this.isClosed = true;
        this.encryptAndWriteBlock();
        this.targetStream.close();
    }

    public long storedLength() throws IOException {
        return this.targetStream.storedLength();
    }

    private void writeHeader() throws IOException {
        this.targetStream.write(HEADER_BYTES);
        this.isHeaderWritten = true;
    }

    private void encryptAndWriteBlock() throws IOException {
        Preconditions.checkState((!this.lastBlockWritten ? 1 : 0) != 0, (Object)"Cannot encrypt block: a partial block has already been written");
        if (this.currentBlockIndex == Integer.MAX_VALUE) {
            throw new IOException("Cannot write block: exceeded Integer.MAX_VALUE blocks");
        }
        if (this.positionInPlainBlock == 0 && this.currentBlockIndex != 0) {
            return;
        }
        if (this.positionInPlainBlock != this.plainBlock.length) {
            this.lastBlockWritten = true;
        }
        byte[] aad = Ciphers.streamBlockAAD(this.fileAadPrefix, this.currentBlockIndex);
        int ciphertextLength = this.gcmEncryptor.encrypt(this.plainBlock, 0, this.positionInPlainBlock, this.cipherBlock, 0, aad);
        this.targetStream.write(this.cipherBlock, 0, ciphertextLength);
        this.positionInPlainBlock = 0;
        ++this.currentBlockIndex;
    }
}

