/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage;

import jakarta.annotation.Nonnull;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.view.ViewMetadata;
import org.apache.polaris.core.storage.StorageLocation;

public class StorageUtil {
    @Nonnull
    public static String concatFilePrefixes(@Nonnull String leftPath, String rightPath, String fileSep) {
        if (leftPath.endsWith(fileSep) && rightPath.startsWith(fileSep)) {
            return leftPath + rightPath.substring(1);
        }
        if (!leftPath.endsWith(fileSep) && !rightPath.startsWith(fileSep)) {
            return leftPath + fileSep + rightPath;
        }
        return leftPath + rightPath;
    }

    @Nonnull
    public static String getBucket(String path) {
        URI uri = URI.create(path);
        return StorageUtil.getBucket(uri);
    }

    @Nonnull
    public static String getBucket(URI uri) {
        return uri.getAuthority();
    }

    @Nonnull
    public static Set<String> getLocationsUsedByTable(TableMetadata tableMetadata) {
        return StorageUtil.getLocationsUsedByTable(tableMetadata.location(), tableMetadata.properties());
    }

    @Nonnull
    public static Set<String> getLocationsUsedByTable(String baseLocation, Map<String, String> properties) {
        HashSet<String> locations = new HashSet<String>();
        locations.add(baseLocation);
        locations.add(properties.get("write.data.path"));
        locations.add(properties.get("write.metadata.path"));
        locations.remove(null);
        return StorageUtil.removeRedundantLocations(locations);
    }

    @Nonnull
    public static Set<String> getLocationsUsedByTable(ViewMetadata viewMetadata) {
        return Set.of(viewMetadata.location());
    }

    @Nonnull
    private static Set<String> removeRedundantLocations(Set<String> locationStrings) {
        HashSet<String> result = new HashSet<String>(locationStrings);
        for (String potentialParent : locationStrings) {
            StorageLocation potentialParentLocation = StorageLocation.of(potentialParent);
            for (String potentialChild : locationStrings) {
                StorageLocation potentialChildLocation;
                if (potentialParent.equals(potentialChild) || !(potentialChildLocation = StorageLocation.of(potentialChild)).isChildOf(potentialParentLocation)) continue;
                result.remove(potentialChild);
            }
        }
        return result;
    }
}

