/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.faulttolerance.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.smallrye.faulttolerance.runtime.QuarkusExistingCircuitBreakerNames;
import io.quarkus.smallrye.faulttolerance.runtime.QuarkusFaultToleranceOperationProvider;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import jakarta.enterprise.inject.spi.DeploymentException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

@Recorder
public class SmallRyeFaultToleranceRecorder {
    public void createFaultToleranceOperation(List<FaultToleranceMethod> ftMethods) {
        ArrayList<Throwable> allExceptions = new ArrayList<Throwable>();
        HashMap<QuarkusFaultToleranceOperationProvider.CacheKey, FaultToleranceOperation> operationCache = new HashMap<QuarkusFaultToleranceOperationProvider.CacheKey, FaultToleranceOperation>(ftMethods.size());
        for (FaultToleranceMethod ftMethod : ftMethods) {
            FaultToleranceOperation operation = new FaultToleranceOperation(ftMethod);
            try {
                operation.validate();
                QuarkusFaultToleranceOperationProvider.CacheKey cacheKey = new QuarkusFaultToleranceOperationProvider.CacheKey(ftMethod.beanClass, ftMethod.method.reflect());
                operationCache.put(cacheKey, operation);
            }
            catch (NoSuchMethodException | FaultToleranceDefinitionException e) {
                allExceptions.add(e);
            }
        }
        if (!allExceptions.isEmpty()) {
            if (allExceptions.size() == 1) {
                Throwable error = (Throwable)allExceptions.get(0);
                if (error instanceof DeploymentException) {
                    throw (DeploymentException)error;
                }
                throw new DeploymentException(error);
            }
            StringBuilder message = new StringBuilder("Found " + allExceptions.size() + " deployment problems: ");
            int idx = 1;
            for (Throwable error : allExceptions) {
                message.append("\n").append("[").append(idx++).append("] ").append(error.getMessage());
            }
            DeploymentException deploymentException = new DeploymentException(message.toString());
            for (Throwable error : allExceptions) {
                deploymentException.addSuppressed(error);
            }
            throw deploymentException;
        }
        ((QuarkusFaultToleranceOperationProvider)Arc.container().instance(QuarkusFaultToleranceOperationProvider.class, new Annotation[0]).get()).init(operationCache);
    }

    public void initExistingCircuitBreakerNames(Set<String> names) {
        ((QuarkusExistingCircuitBreakerNames)Arc.container().instance(QuarkusExistingCircuitBreakerNames.class, new Annotation[0]).get()).init(names);
    }
}

