/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.QueueState;
import org.apache.hadoop.util.StringInterner;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class QueueInfo
implements Writable {
    private String queueName = "";
    private String schedulingInfo;
    private QueueState queueState = QueueState.RUNNING;
    private JobStatus[] stats;
    private List<QueueInfo> children = new ArrayList<QueueInfo>();
    private Properties props = new Properties();

    public QueueInfo() {
    }

    public QueueInfo(String queueName, String schedulingInfo) {
        this();
        this.queueName = queueName;
        this.schedulingInfo = schedulingInfo;
    }

    public QueueInfo(String queueName, String schedulingInfo, QueueState state, JobStatus[] stats) {
        this(queueName, schedulingInfo);
        this.queueState = state;
        this.stats = stats;
    }

    protected void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public String getQueueName() {
        return this.queueName;
    }

    protected void setSchedulingInfo(String schedulingInfo) {
        this.schedulingInfo = schedulingInfo;
    }

    public String getSchedulingInfo() {
        if (this.schedulingInfo != null) {
            return this.schedulingInfo;
        }
        return "N/A";
    }

    protected void setState(QueueState state) {
        this.queueState = state;
    }

    public QueueState getState() {
        return this.queueState;
    }

    protected void setJobStatuses(JobStatus[] stats) {
        this.stats = stats;
    }

    public List<QueueInfo> getQueueChildren() {
        return this.children;
    }

    protected void setQueueChildren(List<QueueInfo> children) {
        this.children = children;
    }

    public Properties getProperties() {
        return this.props;
    }

    protected void setProperties(Properties props) {
        this.props = props;
    }

    public JobStatus[] getJobStatuses() {
        return this.stats;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.queueName = StringInterner.weakIntern(Text.readString(in));
        this.queueState = WritableUtils.readEnum(in, QueueState.class);
        this.schedulingInfo = StringInterner.weakIntern(Text.readString(in));
        int length = in.readInt();
        this.stats = new JobStatus[length];
        for (int i = 0; i < length; ++i) {
            this.stats[i] = new JobStatus();
            this.stats[i].readFields(in);
        }
        int count = in.readInt();
        this.children.clear();
        for (int i = 0; i < count; ++i) {
            QueueInfo childQueueInfo = new QueueInfo();
            childQueueInfo.readFields(in);
            this.children.add(childQueueInfo);
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Text.writeString(out, this.queueName);
        WritableUtils.writeEnum(out, this.queueState);
        if (this.schedulingInfo != null) {
            Text.writeString(out, this.schedulingInfo);
        } else {
            Text.writeString(out, "N/A");
        }
        out.writeInt(this.stats.length);
        for (JobStatus stat : this.stats) {
            stat.write(out);
        }
        out.writeInt(this.children.size());
        for (QueueInfo childQueueInfo : this.children) {
            childQueueInfo.write(out);
        }
    }
}

