/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.TokenPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class NMTokenPBImpl
extends NMToken {
    YarnServiceProtos.NMTokenProto proto = YarnServiceProtos.NMTokenProto.getDefaultInstance();
    YarnServiceProtos.NMTokenProto.Builder builder = null;
    boolean viaProto = false;
    private Token token = null;
    private NodeId nodeId = null;

    public NMTokenPBImpl() {
        this.builder = YarnServiceProtos.NMTokenProto.newBuilder();
    }

    public NMTokenPBImpl(YarnServiceProtos.NMTokenProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    @Override
    public synchronized NodeId getNodeId() {
        YarnServiceProtos.NMTokenProtoOrBuilder p;
        YarnServiceProtos.NMTokenProtoOrBuilder nMTokenProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.nodeId != null) {
            return this.nodeId;
        }
        if (!p.hasNodeId()) {
            return null;
        }
        this.nodeId = this.convertFromProtoFormat(p.getNodeId());
        return this.nodeId;
    }

    @Override
    public synchronized void setNodeId(NodeId nodeId) {
        this.maybeInitBuilder();
        if (nodeId == null) {
            this.builder.clearNodeId();
        }
        this.nodeId = nodeId;
    }

    @Override
    public synchronized Token getToken() {
        YarnServiceProtos.NMTokenProtoOrBuilder p;
        YarnServiceProtos.NMTokenProtoOrBuilder nMTokenProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.token != null) {
            return this.token;
        }
        if (!p.hasToken()) {
            return null;
        }
        this.token = this.convertFromProtoFormat(p.getToken());
        return this.token;
    }

    @Override
    public synchronized void setToken(Token token) {
        this.maybeInitBuilder();
        if (token == null) {
            this.builder.clearToken();
        }
        this.token = token;
    }

    public synchronized YarnServiceProtos.NMTokenProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private synchronized void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private synchronized void mergeLocalToBuilder() {
        if (this.nodeId != null) {
            this.builder.setNodeId(this.convertToProtoFormat(this.nodeId));
        }
        if (this.token != null) {
            this.builder.setToken(this.convertToProtoFormat(this.token));
        }
    }

    private synchronized void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServiceProtos.NMTokenProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    private synchronized NodeId convertFromProtoFormat(YarnProtos.NodeIdProto p) {
        return new NodeIdPBImpl(p);
    }

    private synchronized YarnProtos.NodeIdProto convertToProtoFormat(NodeId nodeId) {
        return ((NodeIdPBImpl)nodeId).getProto();
    }

    private synchronized SecurityProtos.TokenProto convertToProtoFormat(Token token) {
        return ((TokenPBImpl)token).getProto();
    }

    private synchronized Token convertFromProtoFormat(SecurityProtos.TokenProto proto) {
        return new TokenPBImpl(proto);
    }
}

