/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.apache.polaris.core.admin.model.AuthenticationParameters;
import org.apache.polaris.core.admin.model.ConnectionConfigInfo;
import org.apache.polaris.core.admin.model.ServiceIdentityInfo;

@ApiModel(description="Configuration necessary for connecting to an Iceberg REST Catalog")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class IcebergRestConnectionConfigInfo
extends ConnectionConfigInfo {
    private final String remoteCatalogName;

    @ApiModelProperty(value="The name of a remote catalog instance within the remote catalog service; in some older systems this is specified as the 'warehouse' when multiple logical catalogs are served under the same base uri, and often translates into a 'prefix' added to all REST resource paths")
    @JsonProperty(value="remoteCatalogName")
    public String getRemoteCatalogName() {
        return this.remoteCatalogName;
    }

    @JsonCreator
    public IcebergRestConnectionConfigInfo(@JsonProperty(value="remoteCatalogName") String remoteCatalogName, @JsonProperty(value="connectionType", required=true) ConnectionConfigInfo.ConnectionTypeEnum connectionType, @JsonProperty(value="uri") String uri, @JsonProperty(value="authenticationParameters") AuthenticationParameters authenticationParameters, @JsonProperty(value="serviceIdentity") ServiceIdentityInfo serviceIdentity) {
        super(connectionType, uri, authenticationParameters, serviceIdentity);
        this.remoteCatalogName = remoteCatalogName;
    }

    public IcebergRestConnectionConfigInfo(ConnectionConfigInfo.ConnectionTypeEnum connectionType) {
        super(connectionType);
        this.remoteCatalogName = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ConnectionConfigInfo.ConnectionTypeEnum connectionType) {
        return new Builder(connectionType);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IcebergRestConnectionConfigInfo icebergRestConnectionConfigInfo = (IcebergRestConnectionConfigInfo)o;
        return super.equals(o) && Objects.equals(this.remoteCatalogName, icebergRestConnectionConfigInfo.remoteCatalogName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.remoteCatalogName);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IcebergRestConnectionConfigInfo {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    remoteCatalogName: ").append(this.toIndentedString(this.remoteCatalogName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private String remoteCatalogName;
        private ConnectionConfigInfo.ConnectionTypeEnum connectionType;
        private String uri;
        private AuthenticationParameters authenticationParameters;
        private ServiceIdentityInfo serviceIdentity;

        private Builder() {
        }

        private Builder(ConnectionConfigInfo.ConnectionTypeEnum connectionType) {
            this.connectionType = connectionType;
        }

        public Builder setRemoteCatalogName(String remoteCatalogName) {
            this.remoteCatalogName = remoteCatalogName;
            return this;
        }

        public Builder setConnectionType(ConnectionConfigInfo.ConnectionTypeEnum connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        public Builder setUri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder setAuthenticationParameters(AuthenticationParameters authenticationParameters) {
            this.authenticationParameters = authenticationParameters;
            return this;
        }

        public Builder setServiceIdentity(ServiceIdentityInfo serviceIdentity) {
            this.serviceIdentity = serviceIdentity;
            return this;
        }

        public IcebergRestConnectionConfigInfo build() {
            IcebergRestConnectionConfigInfo inst = new IcebergRestConnectionConfigInfo(this.remoteCatalogName, this.connectionType, this.uri, this.authenticationParameters, this.serviceIdentity);
            return inst;
        }
    }
}

