/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.Oidc;
import io.quarkus.oidc.OidcTenantConfigBuilder;
import io.quarkus.oidc.runtime.OidcConfig;
import io.quarkus.oidc.runtime.OidcTenantConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

final class OidcImpl
implements Oidc {
    private final Map<String, io.quarkus.oidc.OidcTenantConfig> staticTenantConfigs;
    private io.quarkus.oidc.OidcTenantConfig defaultTenantConfig;

    OidcImpl(OidcConfig config) {
        this.defaultTenantConfig = io.quarkus.oidc.OidcTenantConfig.of(OidcConfig.getDefaultTenant(config));
        this.staticTenantConfigs = OidcImpl.getStaticTenants(config);
    }

    @Override
    public void create(io.quarkus.oidc.OidcTenantConfig tenantConfig) {
        Objects.requireNonNull(tenantConfig);
        this.putStaticTenantConfig(tenantConfig);
    }

    @Override
    public void createServiceApp(String authServerUrl) {
        this.create(io.quarkus.oidc.OidcTenantConfig.authServerUrl(authServerUrl).applicationType(OidcTenantConfig.ApplicationType.SERVICE).build());
    }

    @Override
    public void createWebApp(String authServerUrl, String clientId, String clientSecret) {
        this.create(((OidcTenantConfigBuilder)((Object)((OidcTenantConfigBuilder)((Object)io.quarkus.oidc.OidcTenantConfig.authServerUrl(authServerUrl).clientId(clientId))).applicationType(OidcTenantConfig.ApplicationType.WEB_APP).credentials(clientSecret))).build());
    }

    Map<String, io.quarkus.oidc.OidcTenantConfig> getStaticTenantConfigs() {
        return Collections.unmodifiableMap(this.staticTenantConfigs);
    }

    io.quarkus.oidc.OidcTenantConfig getDefaultTenantConfig() {
        return this.defaultTenantConfig;
    }

    private void putStaticTenantConfig(io.quarkus.oidc.OidcTenantConfig tenantConfig) {
        String tenantId = tenantConfig.tenantId().get();
        if (this.defaultTenantConfig.tenantId().get().equals(tenantId)) {
            this.defaultTenantConfig = tenantConfig;
        } else {
            this.staticTenantConfigs.put(tenantId, tenantConfig);
        }
    }

    private static Map<String, io.quarkus.oidc.OidcTenantConfig> getStaticTenants(OidcConfig config) {
        HashMap<String, io.quarkus.oidc.OidcTenantConfig> tenantConfigs = new HashMap<String, io.quarkus.oidc.OidcTenantConfig>();
        for (Map.Entry<String, OidcTenantConfig> tenant : config.namedTenants().entrySet()) {
            String tenantKey = tenant.getKey();
            if ("<default>".equals(tenantKey)) continue;
            io.quarkus.oidc.OidcTenantConfig namedTenantConfig = io.quarkus.oidc.OidcTenantConfig.of(tenant.getValue());
            tenantConfigs.put(tenantKey, namedTenantConfig);
        }
        return tenantConfigs;
    }
}

