/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.confignode;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.rpc.thrift.TNodeVersionInfo;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class UpdateVersionInfoPlan
extends ConfigPhysicalPlan {
    private int nodeId;
    private TNodeVersionInfo versionInfo;

    public UpdateVersionInfoPlan() {
        super(ConfigPhysicalPlanType.UpdateVersionInfo);
    }

    public UpdateVersionInfoPlan(TNodeVersionInfo versionInfo, int nodeId) {
        this();
        this.versionInfo = versionInfo;
        this.nodeId = nodeId;
    }

    public TNodeVersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((short)this.getType().getPlanType(), (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.nodeId, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.versionInfo.getVersion(), (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.versionInfo.getBuildInfo(), (OutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) {
        this.nodeId = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        this.versionInfo = new TNodeVersionInfo(ReadWriteIOUtils.readString((ByteBuffer)buffer), ReadWriteIOUtils.readString((ByteBuffer)buffer));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!this.getType().equals((Object)((UpdateVersionInfoPlan)o).getType())) {
            return false;
        }
        UpdateVersionInfoPlan that = (UpdateVersionInfoPlan)o;
        return this.nodeId == that.nodeId && this.versionInfo.equals(that.versionInfo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.nodeId, this.versionInfo);
    }
}

