/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils.ChunkWriterFlushCallback;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils.CompactChunkPlan;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils.CompactPagePlan;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.encoding.encoder.Encoder;
import org.apache.tsfile.encoding.encoder.TSEncodingBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.write.PageException;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.file.metadata.statistics.TimeStatistics;
import org.apache.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.tsfile.write.chunk.IChunkWriter;
import org.apache.tsfile.write.chunk.TimeChunkWriter;
import org.apache.tsfile.write.chunk.ValueChunkWriter;
import org.apache.tsfile.write.page.TimePageWriter;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.VectorMeasurementSchema;
import org.apache.tsfile.write.writer.TsFileIOWriter;

public class FirstBatchCompactionAlignedChunkWriter
extends AlignedChunkWriterImpl {
    private ChunkWriterFlushCallback beforeChunkWriterFlushCallback;

    public FirstBatchCompactionAlignedChunkWriter(VectorMeasurementSchema schema) {
        this.timeChunkWriter = new FirstBatchCompactionTimeChunkWriter(schema.getMeasurementId(), schema.getCompressor(), schema.getTimeTSEncoding(), schema.getTimeEncoder());
        List valueMeasurementIdList = schema.getSubMeasurementsList();
        List valueTSDataTypeList = schema.getSubMeasurementsTSDataTypeList();
        List valueTSEncodingList = schema.getSubMeasurementsTSEncodingList();
        List valueEncoderList = schema.getSubMeasurementsEncoderList();
        this.valueChunkWriterList = new ArrayList(valueMeasurementIdList.size());
        for (int i = 0; i < valueMeasurementIdList.size(); ++i) {
            this.valueChunkWriterList.add(new ValueChunkWriter((String)valueMeasurementIdList.get(i), schema.getCompressor(), (TSDataType)valueTSDataTypeList.get(i), (TSEncoding)valueTSEncodingList.get(i), (Encoder)valueEncoderList.get(i)));
        }
        this.valueIndex = 0;
        this.remainingPointsNumber = this.timeChunkWriter.getRemainingPointNumberForCurrentPage();
    }

    public FirstBatchCompactionAlignedChunkWriter(IMeasurementSchema timeSchema, List<IMeasurementSchema> valueSchemaList) {
        this.timeChunkWriter = new FirstBatchCompactionTimeChunkWriter(timeSchema.getMeasurementId(), timeSchema.getCompressor(), timeSchema.getEncodingType(), timeSchema.getTimeEncoder());
        this.valueChunkWriterList = new ArrayList(valueSchemaList.size());
        for (int i = 0; i < valueSchemaList.size(); ++i) {
            this.valueChunkWriterList.add(new ValueChunkWriter(valueSchemaList.get(i).getMeasurementId(), valueSchemaList.get(i).getCompressor(), valueSchemaList.get(i).getType(), valueSchemaList.get(i).getEncodingType(), valueSchemaList.get(i).getValueEncoder()));
        }
        this.valueIndex = 0;
        this.remainingPointsNumber = this.timeChunkWriter.getRemainingPointNumberForCurrentPage();
    }

    public FirstBatchCompactionAlignedChunkWriter(List<IMeasurementSchema> schemaList) {
        TSEncoding timeEncoding = TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder());
        TSDataType timeType = TSFileDescriptor.getInstance().getConfig().getTimeSeriesDataType();
        CompressionType timeCompression = TSFileDescriptor.getInstance().getConfig().getCompressor(timeType);
        this.timeChunkWriter = new FirstBatchCompactionTimeChunkWriter("", timeCompression, timeEncoding, TSEncodingBuilder.getEncodingBuilder((TSEncoding)timeEncoding).getEncoder(timeType));
        this.valueChunkWriterList = new ArrayList(schemaList.size());
        for (int i = 0; i < schemaList.size(); ++i) {
            this.valueChunkWriterList.add(new ValueChunkWriter(schemaList.get(i).getMeasurementId(), schemaList.get(i).getCompressor(), schemaList.get(i).getType(), schemaList.get(i).getEncodingType(), schemaList.get(i).getValueEncoder()));
        }
        this.valueIndex = 0;
        this.remainingPointsNumber = this.timeChunkWriter.getRemainingPointNumberForCurrentPage();
    }

    public void writeToFileWriter(TsFileIOWriter tsfileWriter) throws IOException {
        if (!this.isEmpty() && this.beforeChunkWriterFlushCallback != null) {
            this.sealCurrentPage();
            this.beforeChunkWriterFlushCallback.call((IChunkWriter)this);
        }
        super.writeToFileWriter(tsfileWriter);
    }

    public void registerBeforeFlushChunkWriterCallback(ChunkWriterFlushCallback flushChunkWriterCallback) {
        this.beforeChunkWriterFlushCallback = flushChunkWriterCallback;
    }

    public CompactChunkPlan getCompactedChunkRecord() {
        return new CompactChunkPlan(((FirstBatchCompactionTimeChunkWriter)this.getTimeChunkWriter()).getPageTimeRanges());
    }

    public static class FirstBatchCompactionTimeChunkWriter
    extends TimeChunkWriter {
        private List<CompactPagePlan> pageTimeRanges = new ArrayList<CompactPagePlan>();

        public FirstBatchCompactionTimeChunkWriter(String measurementId, CompressionType compressionType, TSEncoding encodingType, Encoder timeEncoder) {
            super(measurementId, compressionType, encodingType, timeEncoder);
        }

        public void writePageToPageBuffer() {
            TimePageWriter pageWriter = this.getPageWriter();
            if (pageWriter != null && pageWriter.getPointNumber() > 0L) {
                TimeStatistics statistics = pageWriter.getStatistics();
                this.pageTimeRanges.add(new CompactPagePlan(statistics.getStartTime(), statistics.getEndTime(), false));
                super.writePageToPageBuffer();
            }
        }

        public void writeToFileWriter(TsFileIOWriter tsfileWriter) throws IOException {
            super.writeToFileWriter(tsfileWriter);
            this.pageTimeRanges = new ArrayList<CompactPagePlan>();
        }

        public void writePageHeaderAndDataIntoBuff(ByteBuffer data, PageHeader header) throws PageException {
            this.pageTimeRanges.add(new CompactPagePlan(header.getStartTime(), header.getEndTime(), true));
            super.writePageHeaderAndDataIntoBuff(data, header);
        }

        public List<CompactPagePlan> getPageTimeRanges() {
            return this.pageTimeRanges;
        }
    }
}

