/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.james.mime4j.dom.BinaryBody;
import org.apache.james.mime4j.dom.Body;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.dom.TextBody;
import org.apache.james.mime4j.dom.field.ContentDispositionField;
import org.apache.james.mime4j.dom.field.ContentTransferEncodingField;
import org.apache.james.mime4j.dom.field.ContentTypeField;
import org.apache.james.mime4j.dom.field.FieldName;
import org.apache.james.mime4j.dom.field.ParsedField;
import org.apache.james.mime4j.field.Fields;
import org.apache.james.mime4j.message.MultipartBuilder;
import org.apache.james.mime4j.message.SingleBodyBuilder;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.NameValuePair;
import org.apache.james.mime4j.util.MimeUtil;

public abstract class AbstractEntityBuilder {
    private final List<Field> fields = new LinkedList<Field>();
    private final Map<String, List<Field>> fieldMap = new HashMap<String, List<Field>>();
    private Body body;

    public AbstractEntityBuilder addField(Field field2) {
        String lowerCasedFieldName = field2.getNameLowerCase();
        List<Field> values = this.fieldMap.get(lowerCasedFieldName);
        if (values == null) {
            values = new LinkedList<Field>();
            this.fieldMap.put(lowerCasedFieldName, values);
        }
        values.add(field2);
        this.fields.add(field2);
        return this;
    }

    public List<Field> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public Field getField(String name) {
        List<Field> l = this.fieldMap.get(name.toLowerCase(Locale.US));
        if (l != null && !l.isEmpty()) {
            return l.get(0);
        }
        return null;
    }

    public <F extends Field> F getField(String name, Class<F> clazz) {
        List<Field> l = this.fieldMap.get(name.toLowerCase(Locale.US));
        for (int i = 0; i < l.size(); ++i) {
            Field field2 = l.get(i);
            if (!clazz.isInstance(field2)) continue;
            return (F)((Field)clazz.cast(field2));
        }
        return null;
    }

    public boolean containsField(String name) {
        List<Field> l = this.fieldMap.get(name.toLowerCase(Locale.US));
        return l != null && !l.isEmpty();
    }

    public List<Field> getFields(String name) {
        String lowerCaseName = name.toLowerCase(Locale.US);
        List<Field> l = this.fieldMap.get(lowerCaseName);
        List<Field> results = l == null || l.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(l);
        return results;
    }

    public <F extends Field> List<F> getFields(String name, Class<F> clazz) {
        String lowerCaseName = name.toLowerCase(Locale.US);
        List<Field> l = this.fieldMap.get(lowerCaseName);
        if (l == null) {
            return Collections.emptyList();
        }
        ArrayList<Field> results = new ArrayList<Field>();
        for (int i = 0; i < l.size(); ++i) {
            Field field2 = l.get(i);
            if (!clazz.isInstance(field2)) continue;
            results.add((Field)clazz.cast(field2));
        }
        return results;
    }

    public AbstractEntityBuilder removeFields(String name) {
        String lowerCaseName = name.toLowerCase(Locale.US);
        List<Field> removed = this.fieldMap.remove(lowerCaseName);
        if (removed == null || removed.isEmpty()) {
            return this;
        }
        Iterator<Field> iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            Field field2 = iterator.next();
            if (!field2.getName().equalsIgnoreCase(name)) continue;
            iterator.remove();
        }
        return this;
    }

    public AbstractEntityBuilder setField(Field field2) {
        String lowerCaseName = field2.getNameLowerCase();
        List<Field> l = this.fieldMap.get(lowerCaseName);
        if (l == null || l.isEmpty()) {
            this.addField(field2);
            return this;
        }
        l.clear();
        l.add(field2);
        int firstOccurrence = -1;
        int index = 0;
        Iterator<Field> iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            Field f = iterator.next();
            if (f.getName().equalsIgnoreCase(field2.getName())) {
                iterator.remove();
                if (firstOccurrence == -1) {
                    firstOccurrence = index;
                }
            }
            ++index;
        }
        this.fields.add(firstOccurrence, field2);
        return this;
    }

    public AbstractEntityBuilder clearFields() {
        this.fields.clear();
        this.fieldMap.clear();
        return this;
    }

    public <F extends ParsedField> F obtainField(String fieldName) {
        return (F)((ParsedField)this.getField(fieldName));
    }

    public String getMimeType() {
        ContentTypeField field2 = (ContentTypeField)this.obtainField(FieldName.CONTENT_TYPE_LOWERCASE);
        return field2 != null ? field2.getMimeType() : null;
    }

    public String getCharset() {
        ContentTypeField field2 = (ContentTypeField)this.obtainField(FieldName.CONTENT_TYPE_LOWERCASE);
        return field2 != null ? field2.getCharset() : null;
    }

    public AbstractEntityBuilder setContentType(String mimeType, NameValuePair ... parameters) {
        if (mimeType == null) {
            this.removeFields("Content-Type");
        } else {
            this.setField(Fields.contentType(mimeType, parameters));
        }
        return this;
    }

    public String getContentTransferEncoding() {
        ContentTransferEncodingField field2 = (ContentTransferEncodingField)this.obtainField(FieldName.CONTENT_TRANSFER_ENCODING_LOWERCASE);
        return field2 != null ? field2.getEncoding() : null;
    }

    public AbstractEntityBuilder setContentTransferEncoding(String contentTransferEncoding) {
        if (contentTransferEncoding == null) {
            this.removeFields("Content-Transfer-Encoding");
        } else {
            this.setField(Fields.contentTransferEncoding(contentTransferEncoding));
        }
        return this;
    }

    public String getDispositionType() {
        ContentDispositionField field2 = (ContentDispositionField)this.obtainField(FieldName.CONTENT_DISPOSITION_LOWERCASE);
        return field2 != null ? field2.getDispositionType() : null;
    }

    public AbstractEntityBuilder setContentDisposition(String dispositionType) {
        if (dispositionType == null) {
            this.removeFields("Content-Disposition");
        } else {
            this.setField(Fields.contentDisposition(dispositionType));
        }
        return this;
    }

    public AbstractEntityBuilder setContentDisposition(String dispositionType, String filename) {
        if (dispositionType == null) {
            this.removeFields("Content-Disposition");
        } else {
            this.setField(Fields.contentDisposition(dispositionType, filename));
        }
        return this;
    }

    public AbstractEntityBuilder setContentDisposition(String dispositionType, String filename, long size) {
        if (dispositionType == null) {
            this.removeFields("Content-Disposition");
        } else {
            this.setField(Fields.contentDisposition(dispositionType, filename, size));
        }
        return this;
    }

    public AbstractEntityBuilder setContentDisposition(String dispositionType, String filename, long size, Date creationDate, Date modificationDate, Date readDate) {
        if (dispositionType == null) {
            this.removeFields("Content-Disposition");
        } else {
            this.setField(Fields.contentDisposition(dispositionType, filename, size, creationDate, modificationDate, readDate));
        }
        return this;
    }

    public String getFilename() {
        ContentDispositionField field2 = (ContentDispositionField)this.obtainField(FieldName.CONTENT_DISPOSITION_LOWERCASE);
        return field2 != null ? field2.getFilename() : null;
    }

    public long getSize() {
        ContentDispositionField field2 = (ContentDispositionField)this.obtainField(FieldName.CONTENT_DISPOSITION_LOWERCASE);
        return field2 != null ? field2.getSize() : -1L;
    }

    public Date getCreationDate() {
        ContentDispositionField field2 = (ContentDispositionField)this.obtainField(FieldName.CONTENT_DISPOSITION_LOWERCASE);
        return field2 != null ? field2.getCreationDate() : null;
    }

    public Date getModificationDate() {
        ContentDispositionField field2 = (ContentDispositionField)this.obtainField(FieldName.CONTENT_DISPOSITION_LOWERCASE);
        return field2 != null ? field2.getModificationDate() : null;
    }

    public Date getReadDate() {
        ContentDispositionField field2 = (ContentDispositionField)this.obtainField(FieldName.CONTENT_DISPOSITION_LOWERCASE);
        return field2 != null ? field2.getReadDate() : null;
    }

    public AbstractEntityBuilder setBody(Body body) {
        this.body = body;
        if (body == null) {
            this.removeFields("Content-Type");
        }
        return this;
    }

    public AbstractEntityBuilder setBody(SingleBodyBuilder body) throws IOException {
        return this.setBody(body.build());
    }

    public AbstractEntityBuilder setBody(TextBody textBody) {
        this.body = textBody;
        if (textBody != null) {
            String mimeCharset = textBody.getMimeCharset();
            if ("us-ascii".equalsIgnoreCase(mimeCharset)) {
                mimeCharset = null;
            }
            if (mimeCharset != null) {
                this.setField(Fields.contentType("text/plain", new NameValuePair("charset", mimeCharset)));
            } else {
                this.setField(Fields.contentType("text/plain"));
            }
        } else {
            this.removeFields("Content-Type");
        }
        return this;
    }

    public AbstractEntityBuilder setBody(BinaryBody binaryBody) {
        this.body = binaryBody;
        if (binaryBody != null) {
            this.setField(Fields.contentType("application/octet-stream"));
        } else {
            this.removeFields("Content-Type");
        }
        return this;
    }

    public AbstractEntityBuilder setBody(Message message) {
        this.body = message;
        if (message != null) {
            this.setField(Fields.contentType("message/rfc822"));
        } else {
            this.removeFields("Content-Type");
        }
        return this;
    }

    public AbstractEntityBuilder setBody(Message.Builder message) {
        return this.setBody(message.build());
    }

    public AbstractEntityBuilder setBody(Multipart multipart) {
        this.body = multipart;
        if (multipart != null) {
            ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>(multipart.getContentTypeParameters());
            parameters.add(new NameValuePair("boundary", MimeUtil.createUniqueBoundary()));
            this.setField(Fields.contentType("multipart/" + multipart.getSubType(), parameters.toArray(new NameValuePair[0])));
        } else {
            this.removeFields("Content-Type");
        }
        return this;
    }

    public AbstractEntityBuilder setBody(MultipartBuilder multipart) {
        return this.setBody(multipart.build());
    }

    public Body getBody() {
        return this.body;
    }
}

