/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.memory;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.core.Username;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.api.model.User;
import org.apache.james.user.lib.UsersDAO;
import org.apache.james.user.lib.model.Algorithm;
import org.apache.james.user.lib.model.DefaultUser;

public class MemoryUsersDAO
implements UsersDAO,
Configurable {
    private final Map<String, User> userByName = new HashMap<String, User>();
    private Algorithm algo = Algorithm.of((String)"PBKDF2");

    MemoryUsersDAO() {
    }

    public void configure(HierarchicalConfiguration<ImmutableNode> config) {
        this.algo = Algorithm.of((String)config.getString("algorithm", "PBKDF2"), (String)config.getString("hashingMode", Algorithm.HashingMode.PLAIN.name()));
    }

    public void clear() {
        this.userByName.clear();
    }

    public void addUser(Username username, String password) {
        DefaultUser user = new DefaultUser(username, this.algo, this.algo);
        user.setPassword(password);
        this.userByName.put(username.asString(), (User)user);
    }

    public Optional<User> getUserByName(Username name) throws UsersRepositoryException {
        return Optional.ofNullable(this.userByName.get(name.asString()));
    }

    public void updateUser(User user) throws UsersRepositoryException {
        this.getUserByName(user.getUserName()).orElseThrow(() -> new UsersRepositoryException("Please provide an existing user to update"));
        this.userByName.put(user.getUserName().asString(), user);
    }

    public void removeUser(Username name) throws UsersRepositoryException {
        if (this.userByName.remove(name.asString()) == null) {
            throw new UsersRepositoryException("unable to remove unknown user " + name.asString());
        }
    }

    public boolean contains(Username name) {
        return this.userByName.containsKey(name.asString());
    }

    public int countUsers() {
        return this.userByName.size();
    }

    public Iterator<Username> list() {
        return this.userByName.keySet().stream().map(Username::of).iterator();
    }
}

