/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.tasks.RemoveAttributeTypeTaskProperties;
import com.unboundid.ldap.sdk.unboundidds.tasks.Task;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskProperty;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class RemoveAttributeTypeTask
extends Task {
    @NotNull
    static final String REMOVE_ATTRIBUTE_TYPE_TASK_CLASS = "com.unboundid.directory.server.tasks.RemoveAttributeTypeTask";
    @NotNull
    public static final String ATTR_ATTRIBUTE_TYPE = "ds-task-remove-attribute-type-attribute";
    @NotNull
    public static final String OC_REMOVE_ATTRIBUTE_TYPE_TASK = "ds-task-remove-attribute-type";
    @NotNull
    static final TaskProperty PROPERTY_ATTRIBUTE_TYPE = new TaskProperty("ds-task-remove-attribute-type-attribute", TaskMessages.INFO_REMOVE_ATTR_TYPE_DISPLAY_NAME_ATTRIBUTE_TYPE.get(), TaskMessages.INFO_REMOVE_ATTR_TYPE_DESCRIPTION_ATTRIBUTE_TYPE.get(), String.class, true, false, false);
    private static final long serialVersionUID = -3118507632013307187L;
    @NotNull
    private final String attributeType;

    RemoveAttributeTypeTask() {
        this.attributeType = null;
    }

    public RemoveAttributeTypeTask(@NotNull String attributeType) {
        this(new RemoveAttributeTypeTaskProperties(attributeType));
    }

    public RemoveAttributeTypeTask(@NotNull RemoveAttributeTypeTaskProperties properties) {
        super(properties.getTaskID(), REMOVE_ATTRIBUTE_TYPE_TASK_CLASS, properties.getScheduledStartTime(), properties.getDependencyIDs(), properties.getFailedDependencyAction(), properties.getNotifyOnStart(), properties.getNotifyOnCompletion(), properties.getNotifyOnSuccess(), properties.getNotifyOnError(), properties.getAlertOnStart(), properties.getAlertOnSuccess(), properties.getAlertOnError());
        this.attributeType = properties.getAttributeType();
    }

    public RemoveAttributeTypeTask(@NotNull Entry entry) throws TaskException {
        super(entry);
        this.attributeType = entry.getAttributeValue(ATTR_ATTRIBUTE_TYPE);
        if (this.attributeType == null) {
            throw new TaskException(TaskMessages.ERR_REMOVE_ATTR_TYPE_ENTRY_MISSING_ATTR_TYPE.get(entry.getDN(), ATTR_ATTRIBUTE_TYPE));
        }
    }

    public RemoveAttributeTypeTask(@NotNull Map<TaskProperty, List<Object>> properties) throws TaskException {
        super(REMOVE_ATTRIBUTE_TYPE_TASK_CLASS, properties);
        String attrType = null;
        for (Map.Entry<TaskProperty, List<Object>> entry : properties.entrySet()) {
            TaskProperty p = entry.getKey();
            String attrName = StaticUtils.toLowerCase(p.getAttributeName());
            List<Object> values = entry.getValue();
            if (!attrName.equals(ATTR_ATTRIBUTE_TYPE)) continue;
            attrType = RemoveAttributeTypeTask.parseString(p, values, attrType);
        }
        this.attributeType = attrType;
        if (this.attributeType == null) {
            throw new TaskException(TaskMessages.ERR_REMOVE_ATTR_TYPE_PROPS_MISSING_ATTR_TYPE.get(ATTR_ATTRIBUTE_TYPE));
        }
    }

    @Override
    @NotNull
    public String getTaskName() {
        return TaskMessages.INFO_REMOVE_ATTR_TYPE_TASK_NAME.get();
    }

    @Override
    @NotNull
    public String getTaskDescription() {
        return TaskMessages.INFO_REMOVE_ATTR_TYPE_TASK_DESCRIPTION.get();
    }

    @NotNull
    public String getAttributeType() {
        return this.attributeType;
    }

    @Override
    @NotNull
    protected List<String> getAdditionalObjectClasses() {
        return Collections.singletonList(OC_REMOVE_ATTRIBUTE_TYPE_TASK);
    }

    @Override
    @NotNull
    protected List<Attribute> getAdditionalAttributes() {
        return Collections.singletonList(new Attribute(ATTR_ATTRIBUTE_TYPE, this.attributeType));
    }

    @Override
    @NotNull
    public List<TaskProperty> getTaskSpecificProperties() {
        return Collections.singletonList(PROPERTY_ATTRIBUTE_TYPE);
    }

    @Override
    @NotNull
    public Map<TaskProperty, List<Object>> getTaskPropertyValues() {
        LinkedHashMap<TaskProperty, List<Object>> props = new LinkedHashMap<TaskProperty, List<Object>>(StaticUtils.computeMapCapacity(20));
        props.put(PROPERTY_ATTRIBUTE_TYPE, Collections.singletonList(this.attributeType));
        props.putAll(super.getTaskPropertyValues());
        return Collections.unmodifiableMap(props);
    }
}

