/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.channel.ChannelOption;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;
import reactor.netty.DisposableServer;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.netty.http.server.HttpServer;
import reactor.netty.http.server.HttpServerConfig;
import reactor.netty.internal.util.MapUtils;
import reactor.netty.tcp.TcpServerConfig;

final class HttpServerBind
extends HttpServer {
    static final HttpServerBind INSTANCE = new HttpServerBind();
    final HttpServerConfig config;
    static final int DEFAULT_PORT = 0;

    HttpServerBind() {
        HashMap<ChannelOption, Boolean> childOptions = new HashMap<ChannelOption, Boolean>(MapUtils.calculateInitialCapacity((int)2));
        childOptions.put(ChannelOption.AUTO_READ, false);
        childOptions.put(ChannelOption.TCP_NODELAY, true);
        this.config = new HttpServerConfig(Collections.singletonMap(ChannelOption.SO_REUSEADDR, true), childOptions, () -> new InetSocketAddress(0));
    }

    HttpServerBind(HttpServerConfig config) {
        this.config = config;
    }

    public Mono<? extends DisposableServer> bind() {
        if (this.config.sslProvider != null) {
            if ((this.config._protocols & 1) == 1) {
                return Mono.error((Throwable)new IllegalArgumentException("Configured H2 Clear-Text protocol with TLS. Use the non Clear-Text H2 protocol via HttpServer#protocol or disable TLS via HttpServer#noSSL())"));
            }
        } else {
            if ((this.config._protocols & 2) == 2) {
                return Mono.error((Throwable)new IllegalArgumentException("Configured H2 protocol without TLS. Use a Clear-Text H2 protocol via HttpServer#protocol or configure TLS via HttpServer#secure"));
            }
            if ((this.config._protocols & 8) == 8) {
                return Mono.error((Throwable)new IllegalArgumentException("Configured HTTP/3 protocol without TLS. Configure TLS via HttpServer#secure"));
            }
        }
        return super.bind();
    }

    public HttpServerConfig configuration() {
        return this.config;
    }

    public String toString() {
        return "HttpServer{protocols=" + Arrays.asList(this.configuration().protocols) + ", secure=" + this.configuration().isSecure() + '}';
    }

    protected HttpServer duplicate() {
        return new HttpServerBind(new HttpServerConfig(this.config));
    }

    static HttpServer applyTcpServerConfig(TcpServerConfig config) {
        HttpServer httpServer = (HttpServer)((HttpServer)((HttpServer)((HttpServer)HttpServerBind.create().childObserve(config.childObserver())).doOnChannelInit(config.doOnChannelInit())).observe(config.connectionObserver())).runOn(config.loopResources(), config.isPreferNative());
        for (Map.Entry entry : config.attributes().entrySet()) {
            httpServer = (HttpServer)httpServer.attr((AttributeKey)entry.getKey(), entry.getValue());
        }
        if (config.bindAddress() != null) {
            httpServer = httpServer.bindAddress((Supplier<? extends SocketAddress>)config.bindAddress());
        }
        if (config.channelGroup() != null) {
            httpServer = httpServer.channelGroup(config.channelGroup());
        }
        for (Map.Entry entry : config.childAttributes().entrySet()) {
            httpServer = (HttpServer)httpServer.childAttr((AttributeKey)entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : config.childOptions().entrySet()) {
            httpServer = (HttpServer)httpServer.childOption((ChannelOption)entry.getKey(), entry.getValue());
        }
        if (config.doOnBound() != null) {
            httpServer = (HttpServer)httpServer.doOnBound(config.doOnBound());
        }
        if (config.doOnConnection() != null) {
            httpServer = (HttpServer)httpServer.doOnConnection(config.doOnConnection());
        }
        if (config.doOnUnbound() != null) {
            httpServer = (HttpServer)httpServer.doOnUnbound(config.doOnUnbound());
        }
        if (config.loggingHandler() != null) {
            ((HttpServerConfig)httpServer.configuration()).loggingHandler(config.loggingHandler());
        }
        if (config.metricsRecorder() != null) {
            httpServer = httpServer.metrics(true, (Supplier<? extends ChannelMetricsRecorder>)config.metricsRecorder());
        }
        for (Map.Entry entry : config.options().entrySet()) {
            httpServer = (HttpServer)httpServer.option((ChannelOption)entry.getKey(), entry.getValue());
        }
        if (config.sslProvider() != null) {
            httpServer.secure(config.sslProvider());
        }
        return httpServer;
    }
}

