/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class SourceFilter
implements PlainJsonSerializable {
    private final List<String> excludes;
    private final List<String> includes;
    public static final JsonpDeserializer<SourceFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SourceFilter::setupSourceFilterDeserializer);

    private SourceFilter(Builder builder) {
        this.excludes = ApiTypeHelper.unmodifiable(builder.excludes);
        this.includes = ApiTypeHelper.unmodifiable(builder.includes);
    }

    public static SourceFilter of(Function<Builder, ObjectBuilder<SourceFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> excludes() {
        return this.excludes;
    }

    public final List<String> includes() {
        return this.includes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.excludes)) {
            generator.writeKey("excludes");
            generator.writeStartArray();
            for (String item0 : this.excludes) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.includes)) {
            generator.writeKey("includes");
            generator.writeStartArray();
            for (String item0 : this.includes) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupSourceFilterDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::excludes, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "excludes", "exclude");
        op.add(Builder::includes, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "includes", "include");
        op.shortcutProperty("includes");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<SourceFilter> {
        @Nullable
        private List<String> excludes;
        @Nullable
        private List<String> includes;

        public final Builder excludes(List<String> list) {
            this.excludes = Builder._listAddAll(this.excludes, list);
            return this;
        }

        public final Builder excludes(String value, String ... values) {
            this.excludes = Builder._listAdd(this.excludes, value, values);
            return this;
        }

        public final Builder includes(List<String> list) {
            this.includes = Builder._listAddAll(this.includes, list);
            return this;
        }

        public final Builder includes(String value, String ... values) {
            this.includes = Builder._listAdd(this.includes, value, values);
            return this;
        }

        @Override
        public SourceFilter build() {
            this._checkSingleUse();
            return new SourceFilter(this);
        }
    }
}

