/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.snapshot;

import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.snapshot.SnapshotInfo;
import org.opensearch.client.opensearch.snapshot.get.SnapshotResponseItem;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class GetSnapshotResponse
implements PlainJsonSerializable {
    @Nonnull
    private final List<SnapshotInfo> snapshots;
    public static final JsonpDeserializer<GetSnapshotResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetSnapshotResponse::setupGetSnapshotResponseDeserializer);

    private GetSnapshotResponse(Builder builder) {
        this.snapshots = ApiTypeHelper.unmodifiableRequired(builder.snapshots, (Object)this, "snapshots");
    }

    public static GetSnapshotResponse of(Function<Builder, ObjectBuilder<GetSnapshotResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Deprecated
    public final List<SnapshotResponseItem> responses() {
        return Collections.emptyList();
    }

    @Nonnull
    public final List<SnapshotInfo> snapshots() {
        return this.snapshots;
    }

    @Deprecated
    public final int total() {
        return this.snapshots.size();
    }

    @Deprecated
    public final int remaining() {
        return 0;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("snapshots");
        generator.writeStartArray();
        for (SnapshotInfo item0 : this.snapshots) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupGetSnapshotResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::snapshots, JsonpDeserializer.arrayDeserializer(SnapshotInfo._DESERIALIZER), "snapshots");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.snapshots.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetSnapshotResponse other = (GetSnapshotResponse)o;
        return this.snapshots.equals(other.snapshots);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<GetSnapshotResponse> {
        private List<SnapshotInfo> snapshots;

        @Nonnull
        public final Builder snapshots(List<SnapshotInfo> list) {
            this.snapshots = Builder._listAddAll(this.snapshots, list);
            return this;
        }

        @Nonnull
        public final Builder snapshots(SnapshotInfo value, SnapshotInfo ... values) {
            this.snapshots = Builder._listAdd(this.snapshots, value, values);
            return this;
        }

        @Nonnull
        public final Builder snapshots(Function<SnapshotInfo.Builder, ObjectBuilder<SnapshotInfo>> fn) {
            return this.snapshots(fn.apply(new SnapshotInfo.Builder()).build(), new SnapshotInfo[0]);
        }

        @Override
        @Nonnull
        public GetSnapshotResponse build() {
            this._checkSingleUse();
            return new GetSnapshotResponse(this);
        }
    }
}

