/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ReplicationSummaryReplicationServer
implements Serializable {
    private static final long serialVersionUID = -3021672478708746554L;
    @Nullable
    private final Date replicationServerLastConnected;
    @Nullable
    private final Date replicationServerLastFailed;
    @Nullable
    private final Long replicationServerFailedAttempts;
    @Nullable
    private final Long replicationServerPort;
    @Nullable
    private final String generationID;
    @Nullable
    private final String replicationServerAddress;
    @Nullable
    private final String replicationServerID;
    @Nullable
    private final String replicationServerStatus;
    @NotNull
    private final String stringRepresentation;

    public ReplicationSummaryReplicationServer(@NotNull String value) {
        this.stringRepresentation = value;
        this.generationID = ReplicationSummaryReplicationServer.getElementValue(value, "generation-id");
        this.replicationServerID = ReplicationSummaryReplicationServer.getElementValue(value, "server-id");
        String hostPort = ReplicationSummaryReplicationServer.getElementValue(value, "server");
        if (hostPort == null) {
            this.replicationServerAddress = null;
            this.replicationServerPort = null;
        } else {
            Long p;
            String a;
            try {
                int colonPos = hostPort.indexOf(58);
                a = hostPort.substring(0, colonPos);
                p = Long.parseLong(hostPort.substring(colonPos + 1));
            }
            catch (Exception e) {
                Debug.debugException(e);
                a = null;
                p = null;
            }
            this.replicationServerAddress = a;
            this.replicationServerPort = p;
        }
        this.replicationServerStatus = ReplicationSummaryReplicationServer.getElementValue(value, "status");
        this.replicationServerLastConnected = ReplicationSummaryReplicationServer.getElementDateValue(value, "last-connected");
        this.replicationServerLastFailed = ReplicationSummaryReplicationServer.getElementDateValue(value, "last-failed");
        this.replicationServerFailedAttempts = ReplicationSummaryReplicationServer.getElementLongValue(value, "failed-attempts");
    }

    @Nullable
    private static String getElementValue(@NotNull String s, @NotNull String n) {
        String nPlusEQ = n + "=\"";
        int pos = s.indexOf(nPlusEQ);
        if (pos < 0) {
            return null;
        }
        int closePos = s.indexOf(34, pos += nPlusEQ.length());
        if (closePos <= pos) {
            return null;
        }
        return s.substring(pos, closePos);
    }

    @Nullable
    private static Date getElementDateValue(@NotNull String s, @NotNull String n) {
        String stringValue = ReplicationSummaryReplicationServer.getElementValue(s, n);
        if (stringValue == null) {
            return null;
        }
        try {
            SimpleDateFormat f = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
            return f.parse(stringValue);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    @Nullable
    private static Long getElementLongValue(@NotNull String s, @NotNull String n) {
        String stringValue = ReplicationSummaryReplicationServer.getElementValue(s, n);
        if (stringValue == null) {
            return null;
        }
        try {
            return Long.valueOf(stringValue);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    @Nullable
    public String getReplicationServerID() {
        return this.replicationServerID;
    }

    @Nullable
    public String getReplicationServerAddress() {
        return this.replicationServerAddress;
    }

    @Nullable
    public Long getReplicationServerPort() {
        return this.replicationServerPort;
    }

    @Nullable
    public String getGenerationID() {
        return this.generationID;
    }

    @Nullable
    public String getReplicationServerStatus() {
        return this.replicationServerStatus;
    }

    @Nullable
    public Date getReplicationServerLastConnected() {
        return this.replicationServerLastConnected;
    }

    @Nullable
    public Date getReplicationServerLastFailed() {
        return this.replicationServerLastFailed;
    }

    @Nullable
    public Long getReplicationServerFailedAttempts() {
        return this.replicationServerFailedAttempts;
    }

    @NotNull
    public String toString() {
        return this.stringRepresentation;
    }
}

