/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.facet.utils;

import java.io.IOException;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.FacetLabel;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.sandbox.facet.cutters.FacetCutter;
import org.apache.lucene.sandbox.facet.cutters.TaxonomyFacetsCutter;
import org.apache.lucene.sandbox.facet.iterators.OrdinalIterator;
import org.apache.lucene.sandbox.facet.iterators.TaxonomyChildrenOrdinalIterator;
import org.apache.lucene.sandbox.facet.labels.TaxonomyOrdLabelBiMap;
import org.apache.lucene.sandbox.facet.utils.BaseFacetBuilder;

public final class TaxonomyFacetBuilder
extends BaseFacetBuilder<TaxonomyFacetBuilder> {
    private final FacetsConfig facetsConfig;
    private final FacetsConfig.DimConfig dimConfig;
    private final TaxonomyReader taxonomyReader;
    private final String indexFieldName;
    private final CollectionKey collectionKey;
    private TaxonomyOrdLabelBiMap taxoOrdLabels;
    private int parentOrd = -1;

    public TaxonomyFacetBuilder(FacetsConfig facetsConfig, TaxonomyReader taxonomyReader, String dimension, String ... path) {
        super(dimension, path);
        if (!facetsConfig.isDimConfigured(dimension)) {
            throw new IllegalArgumentException("Dimension config for " + dimension + " is required. Call one of the FacetsConfig's setter with a default value.");
        }
        this.facetsConfig = facetsConfig;
        this.taxonomyReader = taxonomyReader;
        this.dimConfig = facetsConfig.getDimConfig(dimension);
        this.indexFieldName = this.dimConfig.indexFieldName;
        this.collectionKey = new CollectionKey(this.indexFieldName);
        this.withSortByCount();
    }

    @Override
    Object collectionKey() {
        return this.collectionKey;
    }

    @Override
    FacetCutter getFacetCutter() {
        return new TaxonomyFacetsCutter(this.indexFieldName, this.facetsConfig, this.taxonomyReader);
    }

    private int getParentOrd() throws IOException {
        if (this.parentOrd < 0) {
            FacetLabel parentLabel = new FacetLabel(this.dimension, this.path);
            this.parentOrd = this.getOrdToLabel().getOrd(parentLabel);
        }
        return this.parentOrd;
    }

    @Override
    OrdinalIterator getMatchingOrdinalIterator() throws IOException {
        return new TaxonomyChildrenOrdinalIterator(super.getMatchingOrdinalIterator(), this.taxonomyReader.getParallelTaxonomyArrays().parents(), this.getParentOrd());
    }

    @Override
    Number getOverallValue() throws IOException {
        if (!this.dimConfig.multiValued || this.dimConfig.requireDimCount) {
            return this.getValue(this.getParentOrd());
        }
        return -1;
    }

    @Override
    TaxonomyOrdLabelBiMap getOrdToLabel() {
        if (this.taxoOrdLabels == null) {
            this.taxoOrdLabels = new TaxonomyOrdLabelBiMap(this.taxonomyReader);
        }
        return this.taxoOrdLabels;
    }

    @Override
    TaxonomyFacetBuilder self() {
        return this;
    }

    private record CollectionKey(String indexFieldName) {
    }
}

