/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedSetDocValues;

public class StringDocValuesReaderState {
    final IndexReader reader;
    final String field;
    final OrdinalMap ordinalMap;

    public StringDocValuesReaderState(IndexReader reader, String field) throws IOException {
        this.reader = reader;
        this.field = field;
        this.ordinalMap = StringDocValuesReaderState.buildOrdinalMap(reader, field);
    }

    private static OrdinalMap buildOrdinalMap(IndexReader reader, String field) throws IOException {
        List leaves = reader.leaves();
        int leafCount = leaves.size();
        if (leafCount <= 1) {
            return null;
        }
        SortedSetDocValues[] docValues = new SortedSetDocValues[leafCount];
        for (int i = 0; i < leafCount; ++i) {
            LeafReaderContext context = (LeafReaderContext)reader.leaves().get(i);
            docValues[i] = DocValues.getSortedSet((LeafReader)context.reader(), (String)field);
        }
        IndexReader.CacheHelper cacheHelper = reader.getReaderCacheHelper();
        IndexReader.CacheKey owner = cacheHelper == null ? null : cacheHelper.getKey();
        return OrdinalMap.build((IndexReader.CacheKey)owner, (SortedSetDocValues[])docValues, (float)0.25f);
    }

    public String toString() {
        return "StringDocValuesReaderState(field=" + this.field + " reader=" + String.valueOf(this.reader) + ")";
    }
}

