/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.response.error;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.response.Error;
import com.datastax.oss.protocol.internal.response.error.ReadFailure;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Map;

public class WriteFailure
extends Error {
    public final int consistencyLevel;
    public final int received;
    public final int blockFor;
    public final int numFailures;
    public final Map<InetAddress, Integer> reasonMap;
    public final String writeType;

    public WriteFailure(String message, int consistencyLevel, int received, int blockFor, int numFailures, Map<InetAddress, Integer> reasonMap, String writeType) {
        super(5376, message);
        this.consistencyLevel = consistencyLevel;
        this.received = received;
        this.blockFor = blockFor;
        this.numFailures = numFailures;
        this.reasonMap = reasonMap;
        this.writeType = writeType;
    }

    public static class SubCodec
    extends Error.SubCodec {
        public SubCodec(int protocolVersion) {
            super(5376, protocolVersion);
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder) {
            WriteFailure writeFailure = (WriteFailure)message;
            encoder.writeString(writeFailure.message, dest);
            encoder.writeUnsignedShort(writeFailure.consistencyLevel, dest);
            encoder.writeInt(writeFailure.received, dest);
            encoder.writeInt(writeFailure.blockFor, dest);
            if (this.protocolVersion >= 5) {
                ReadFailure.SubCodec.writeReasonMap(writeFailure.reasonMap, dest, encoder);
            } else {
                encoder.writeInt(writeFailure.numFailures, dest);
            }
            encoder.writeString(writeFailure.writeType, dest);
        }

        @Override
        public int encodedSize(Message message) {
            WriteFailure writeFailure = (WriteFailure)message;
            int size = PrimitiveSizes.sizeOfString(writeFailure.message) + 2 + 4 + 4 + PrimitiveSizes.sizeOfString(writeFailure.writeType);
            size = this.protocolVersion >= 5 ? (size += ReadFailure.SubCodec.sizeOfReasonMap(writeFailure.reasonMap)) : (size += 4);
            return size;
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder) {
            int numFailures;
            Map<Object, Object> reasonMap;
            String message = decoder.readString(source);
            int consistencyLevel = decoder.readUnsignedShort(source);
            int received = decoder.readInt(source);
            int blockFor = decoder.readInt(source);
            if (this.protocolVersion >= 5) {
                reasonMap = ReadFailure.SubCodec.readReasonMap(source, decoder);
                numFailures = reasonMap.size();
            } else {
                reasonMap = Collections.emptyMap();
                numFailures = decoder.readInt(source);
            }
            String writeType = decoder.readString(source);
            return new WriteFailure(message, consistencyLevel, received, blockFor, numFailures, reasonMap, writeType);
        }
    }
}

