/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.util.ByteString;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DNEscapingStrategy
implements Serializable {
    @NotNull
    public static final DNEscapingStrategy DEFAULT = new DNEscapingStrategy(true, false, true, true);
    @NotNull
    public static final DNEscapingStrategy MINIMAL = new DNEscapingStrategy(false, false, false, false);
    @NotNull
    public static final DNEscapingStrategy MAXIMAL = new DNEscapingStrategy(true, true, true, true);
    private static final long serialVersionUID = -5438646712027992419L;
    private final boolean escapeASCIIControlCharacters;
    private final boolean escapeDisplayableNonASCIICharacters;
    private final boolean escapeNonDisplayableNonASCIICharacters;
    private final boolean escapeNonUTF8Data;

    public DNEscapingStrategy(boolean escapeASCIIControlCharacters, boolean escapeDisplayableNonASCIICharacters, boolean escapeNonDisplayableNonASCIICharacters, boolean escapeNonUTF8Data) {
        this.escapeASCIIControlCharacters = escapeASCIIControlCharacters;
        this.escapeDisplayableNonASCIICharacters = escapeDisplayableNonASCIICharacters;
        this.escapeNonDisplayableNonASCIICharacters = escapeNonDisplayableNonASCIICharacters;
        this.escapeNonUTF8Data = escapeNonUTF8Data;
    }

    public boolean escapeASCIIControlCharacters() {
        return this.escapeASCIIControlCharacters;
    }

    public boolean escapeDisplayableNonASCIICharacters() {
        return this.escapeDisplayableNonASCIICharacters;
    }

    public boolean escapeNonDisplayableNonASCIICharacters() {
        return this.escapeNonDisplayableNonASCIICharacters;
    }

    public boolean escapeNonUTF8Data() {
        return this.escapeNonUTF8Data;
    }

    public void escape(@NotNull byte[] value, @NotNull ByteStringBuffer buffer) {
        int valueLength = value.length;
        if (value == null || valueLength == 0) {
            return;
        }
        Boolean isNonUTF8 = null;
        block6: for (int i = 0; i < valueLength; ++i) {
            byte b = value[i];
            switch (b) {
                case 34: 
                case 43: 
                case 44: 
                case 59: 
                case 60: 
                case 62: 
                case 92: {
                    buffer.append('\\');
                    buffer.append(b);
                    continue block6;
                }
                case 0: {
                    buffer.append("\\00");
                    continue block6;
                }
                case 32: {
                    if (i == 0 || i == valueLength - 1) {
                        buffer.append('\\');
                    }
                    buffer.append(b);
                    continue block6;
                }
                case 35: {
                    if (i == 0) {
                        buffer.append('\\');
                    }
                    buffer.append(b);
                    continue block6;
                }
                default: {
                    if (b >= 0 && b <= 31 || b == 127) {
                        if (this.escapeASCIIControlCharacters) {
                            buffer.append('\\');
                            buffer.append(StaticUtils.toHex(b));
                            continue block6;
                        }
                        buffer.append(b);
                        continue block6;
                    }
                    if (b > 0) {
                        buffer.append(b);
                        continue block6;
                    }
                    if (isNonUTF8 == null) {
                        byte[] remainingValueBytes = new byte[valueLength - i];
                        System.arraycopy(value, i, remainingValueBytes, 0, remainingValueBytes.length);
                        if (StaticUtils.isValidUTF8(remainingValueBytes)) {
                            this.escape(StaticUtils.toUTF8String(remainingValueBytes), buffer, i == 0);
                            return;
                        }
                        isNonUTF8 = Boolean.TRUE;
                    }
                    if (this.escapeNonUTF8Data) {
                        buffer.append('\\');
                        buffer.append(StaticUtils.toHex(b));
                        continue block6;
                    }
                    buffer.append(b);
                }
            }
        }
    }

    public void escape(@NotNull String value, @NotNull ByteStringBuffer buffer) {
        this.escape(value, buffer, true);
    }

    public void escape(@NotNull ByteString value, @NotNull ByteStringBuffer buffer) {
        this.escape(value.getValue(), buffer);
    }

    private void escape(@NotNull String value, @NotNull ByteStringBuffer buffer, boolean isWholeString) {
        int charsPerCodePoint;
        if (value == null || value.isEmpty()) {
            return;
        }
        for (int pos = 0; pos < value.length(); pos += charsPerCodePoint) {
            int codePoint = value.codePointAt(pos);
            switch (codePoint) {
                case 34: 
                case 43: 
                case 44: 
                case 59: 
                case 60: 
                case 62: 
                case 92: {
                    buffer.append('\\');
                    buffer.append((byte)codePoint);
                    break;
                }
                case 0: {
                    buffer.append("\\00");
                    break;
                }
                case 32: {
                    if (pos == 0 && isWholeString || pos == value.length() - 1) {
                        buffer.append('\\');
                    }
                    buffer.append(' ');
                    break;
                }
                case 35: {
                    if (pos == 0 && isWholeString) {
                        buffer.append('\\');
                    }
                    buffer.append('#');
                    break;
                }
                default: {
                    if (codePoint >= 0 && codePoint <= 31 || codePoint == 127) {
                        byte codePointByte = (byte)codePoint;
                        if (this.escapeASCIIControlCharacters) {
                            buffer.append('\\');
                            buffer.append(StaticUtils.toHex(codePointByte));
                            break;
                        }
                        buffer.append(codePointByte);
                        break;
                    }
                    if (codePoint < 127) {
                        buffer.append((byte)codePoint);
                        break;
                    }
                    String codePointString = new String(new int[]{codePoint}, 0, 1);
                    byte[] codePointBytes = StaticUtils.getBytes(codePointString);
                    if (StaticUtils.isLikelyDisplayableCharacter(codePoint)) {
                        if (this.escapeDisplayableNonASCIICharacters) {
                            for (byte b : codePointBytes) {
                                buffer.append('\\');
                                buffer.append(StaticUtils.toHex(b));
                            }
                            break;
                        }
                        buffer.append(codePointBytes);
                        break;
                    }
                    if (this.escapeNonDisplayableNonASCIICharacters) {
                        for (byte b : codePointBytes) {
                            buffer.append('\\');
                            buffer.append(StaticUtils.toHex(b));
                        }
                        break;
                    }
                    buffer.append(codePointBytes);
                }
            }
            charsPerCodePoint = Character.charCount(codePoint);
        }
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("DNEscapingStrategy(escapeASCIIControlCharacters=");
        buffer.append(this.escapeASCIIControlCharacters);
        buffer.append(", escapeDisplayableNonASCIICharacters=");
        buffer.append(this.escapeDisplayableNonASCIICharacters);
        buffer.append(", escapeNonDisplayableNonASCIICharacters=");
        buffer.append(this.escapeNonDisplayableNonASCIICharacters);
        buffer.append(", escapeNonUTF8Data=");
        buffer.append(this.escapeNonUTF8Data);
        buffer.append(')');
    }
}

