/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.migrate.ldapjdk;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPControl;
import com.unboundid.util.Extensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;

@Extensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class LDAPResponse
implements Serializable {
    private static final long serialVersionUID = -8401666939604882177L;
    @NotNull
    private final LDAPResult ldapResult;

    public LDAPResponse(@NotNull LDAPResult ldapResult) {
        this.ldapResult = ldapResult;
    }

    public int getMessageID() {
        return this.ldapResult.getMessageID();
    }

    public int getResultCode() {
        return this.ldapResult.getResultCode().intValue();
    }

    @Nullable
    public String getErrorMessage() {
        return this.ldapResult.getDiagnosticMessage();
    }

    @Nullable
    public String getMatchedDN() {
        return this.ldapResult.getMatchedDN();
    }

    @Nullable
    public String[] getReferrals() {
        String[] referrals = this.ldapResult.getReferralURLs();
        if (referrals.length == 0) {
            return null;
        }
        return referrals;
    }

    @Nullable
    public LDAPControl[] getControls() {
        Control[] controls = this.ldapResult.getResponseControls();
        if (controls.length == 0) {
            return null;
        }
        return LDAPControl.toLDAPControls(controls);
    }

    @NotNull
    public final LDAPResult toLDAPResult() {
        return this.ldapResult;
    }

    @NotNull
    public String toString() {
        return this.ldapResult.toString();
    }
}

